"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IpPrefixParamEditor = IpPrefixParamEditor;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/ip_prefix.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isPrefixValid({
  prefixLength,
  isIpv6
}) {
  if (prefixLength < 0) {
    return false;
  } else if (prefixLength > 32 && !isIpv6) {
    return false;
  } else if (prefixLength > 128 && isIpv6) {
    return false;
  }
  return true;
}
const prefixLengthLabel = _i18n.i18n.translate('visDefaultEditor.controls.IpPrefix.prefixLength', {
  defaultMessage: 'Prefix length'
});
const isIpv6Label = _i18n.i18n.translate('visDefaultEditor.controls.IpPrefix.isIpv6', {
  defaultMessage: 'Prefix applies to IPv6 addresses'
});
function IpPrefixParamEditor({
  agg,
  value = {},
  setTouched,
  setValue,
  setValidity,
  showValidation
}) {
  const isValid = isPrefixValid(value);
  let error;
  if (!isValid) {
    if (!value.isIpv6) {
      error = _i18n.i18n.translate('visDefaultEditor.controls.ipPrefix.errorMessageIpv4', {
        defaultMessage: 'Prefix length must be between 0 and 32 for IPv4 addresses.'
      });
    } else {
      error = _i18n.i18n.translate('visDefaultEditor.controls.ipPrefix.errorMessageIpv6', {
        defaultMessage: 'Prefix length must be between 0 and 128 for IPv6 addresses.'
      });
    }
  }
  (0, _utils.useValidation)(setValidity, isValid);
  const onPrefixLengthChange = (0, _react.useCallback)(ev => {
    setValue({
      ...value,
      prefixLength: ev.target.valueAsNumber
    });
  }, [setValue, value]);
  const onIsIpv6Change = (0, _react.useCallback)(ev => {
    setValue({
      ...value,
      isIpv6: ev.target.checked
    });
  }, [setValue, value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "rowCompressed",
    label: prefixLengthLabel,
    isInvalid: showValidation ? !isValid : false,
    error: error,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    direction: 'column',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: value.prefixLength,
    onChange: onPrefixLengthChange,
    fullWidth: true,
    compressed: true,
    onBlur: setTouched,
    min: 0,
    max: value.isIpv6 ? 128 : 32,
    "data-test-subj": `visEditorIpPrefixPrefixLength`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: value.isIpv6,
    label: isIpv6Label,
    onChange: onIsIpv6Change,
    compressed: true,
    "data-test-subj": `visEditorIpPrefixIsIpv6`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }))));
}