"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimpleNumberList = SimpleNumberList;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("./number_list/utils");
var _number_row = require("./number_list/number_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/controls/components/simple_number_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const generateId = (0, _eui.htmlIdGenerator)();
function SimpleNumberList({
  agg,
  aggParam,
  value,
  setValue,
  setTouched
}) {
  const [numbers, setNumbers] = (0, _react.useState)((0, _utils.getInitModelList)(value && (0, _lodash.isArray)(value) ? value : [_utils.EMPTY_STRING]));
  const numberRange = (0, _react.useMemo)(() => (0, _utils.getRange)('[-Infinity,Infinity]'), []);

  // This useEffect is needed to discard changes, it sets numbers a mapped value if they are different
  (0, _react.useEffect)(() => {
    if ((0, _lodash.isArray)(value) && (value.length !== numbers.length || !value.every((numberValue, index) => numberValue === numbers[index].value))) {
      setNumbers(value.map(numberValue => ({
        id: generateId(),
        value: numberValue,
        isInvalid: false
      })));
    }
  }, [numbers, value]);
  const onUpdate = (0, _react.useCallback)(numberList => {
    setNumbers(numberList);
    setValue(numberList.map(({
      value: numberValue
    }) => numberValue));
  }, [setValue]);
  const onChangeValue = (0, _react.useCallback)(numberField => {
    onUpdate(numbers.map(number => number.id === numberField.id ? {
      id: numberField.id,
      value: (0, _utils.parse)(numberField.value),
      isInvalid: false
    } : number));
  }, [numbers, onUpdate]);

  // Add an item to the end of the list
  const onAdd = (0, _react.useCallback)(() => {
    const newArray = [...numbers, {
      id: generateId(),
      value: _utils.EMPTY_STRING,
      isInvalid: false
    }];
    onUpdate(newArray);
  }, [numbers, onUpdate]);
  const onDelete = (0, _react.useCallback)(id => onUpdate(numbers.filter(number => number.id !== id)), [numbers, onUpdate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: `${aggParam.name}-${agg.id}}`,
    label: aggParam.displayName || aggParam.name,
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, numbers.map((number, arrayIndex) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: number.id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_number_row.NumberRow, {
    isInvalid: number.isInvalid,
    disableDelete: numbers.length === 1,
    model: number,
    labelledbyId: `${aggParam.name}-${agg.id}-legend`,
    range: numberRange,
    onDelete: onDelete,
    onChange: onChangeValue,
    onBlur: setTouched,
    autoFocus: numbers.length !== 1 && arrayIndex === numbers.length - 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }), numbers.length - 1 !== arrayIndex && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 51
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.controls.includeExclude.addUnitButtonLabel",
    defaultMessage: "Add value",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  })))));
}