"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorAggSelect = DefaultEditorAggSelect;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _agg_params_state = require("./agg_params_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/agg_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DefaultEditorAggSelect({
  aggError,
  id,
  indexPattern,
  value,
  setValue,
  aggTypeOptions,
  showValidation,
  isSubAggregation,
  onChangeAggType
}) {
  const [isDirty, setIsDirty] = (0, _react.useState)(false);
  const {
    services
  } = (0, _public.useKibana)();
  const selectedOptions = value ? [{
    label: value.title,
    target: value
  }] : [];
  const label = isSubAggregation ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggSelect.subAggregationLabel",
    defaultMessage: "Sub aggregation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggSelect.aggregationLabel",
    defaultMessage: "Aggregation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  });
  let aggHelpLink;
  if ((0, _lodash.has)(value, 'name')) {
    // @ts-expect-error
    aggHelpLink = services.docLinks.links.aggs[value.name];
  }
  const helpLink = value && aggHelpLink && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: aggHelpLink,
    target: "_blank",
    rel: "noopener",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "visDefaultEditor.aggSelect.helpLinkLabel",
    defaultMessage: "{aggTitle} help",
    values: {
      aggTitle: value ? value.title : ''
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  })));
  const errors = aggError ? [aggError] : [];
  if (!aggTypeOptions.length) {
    errors.push(_i18n.i18n.translate('visDefaultEditor.aggSelect.noCompatibleAggsDescription', {
      defaultMessage: 'The index pattern {indexPatternTitle} does not have any aggregatable fields.',
      values: {
        indexPatternTitle: indexPattern && indexPattern.title
      }
    }));
  }
  const isValid = !!value && !errors.length && !isDirty;
  const onChange = (0, _react.useCallback)(options => {
    const selectedOption = (0, _lodash.get)(options, '0.target');
    if (selectedOption) {
      setValue(selectedOption);
    }
  }, [setValue]);
  const onSearchChange = (0, _react.useCallback)(searchValue => setIsDirty(Boolean(searchValue)), []);
  const setTouched = (0, _react.useCallback)(() => onChangeAggType({
    type: _agg_params_state.AGG_TYPE_ACTION_KEYS.TOUCHED,
    payload: true
  }), [onChangeAggType]);
  const setValidity = (0, _react.useCallback)(valid => onChangeAggType({
    type: _agg_params_state.AGG_TYPE_ACTION_KEYS.VALID,
    payload: valid
  }), [onChangeAggType]);
  (0, _react.useEffect)(() => {
    setValidity(isValid);
  }, [isValid, setValidity]);
  (0, _react.useEffect)(() => {
    if (errors.length) {
      setTouched();
    }
  }, [errors.length, setTouched]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    labelAppend: helpLink,
    error: errors,
    isInvalid: showValidation ? !isValid : false,
    fullWidth: true,
    display: "rowCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    placeholder: _i18n.i18n.translate('visDefaultEditor.aggSelect.selectAggPlaceholder', {
      defaultMessage: 'Select an aggregation'
    }),
    id: `visDefaultEditorAggSelect${id}`,
    isDisabled: !aggTypeOptions.length,
    options: aggTypeOptions,
    selectedOptions: selectedOptions,
    singleSelection: {
      asPlainText: true
    },
    onBlur: setTouched,
    onChange: onChange,
    onSearchChange: onSearchChange,
    "data-test-subj": "defaultEditorAggSelect",
    isClearable: false,
    isInvalid: showValidation ? !isValid : false,
    fullWidth: true,
    sortMatchesBy: "startsWith",
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }));
}