"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEditorAggParams = DefaultEditorAggParams;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _agg_select = require("./agg_select");
var _agg_param = require("./agg_param");
var _agg_params_helper = require("./agg_params_helper");
var _agg_params_state = require("./agg_params_state");
var _utils = require("./utils");
var _schemas = require("../schemas");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/vis_default_editor/public/components/agg_params.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIXED_VALUE_PROP = 'fixedValue';
const DEFAULT_PROP = 'default';
function DefaultEditorAggParams({
  agg,
  aggError,
  aggIndex = 0,
  aggIsTooLow = false,
  className,
  disabledParams,
  groupName,
  formIsTouched,
  indexPattern,
  metricAggs,
  state,
  setAggParamValue,
  onAggTypeChange,
  setTouched,
  setValidity,
  schemas,
  allowedAggs = [],
  hideCustomLabel = false
}) {
  var _agg$type, _agg$params, _agg$params$field;
  const schema = (0, _react.useMemo)(() => (0, _schemas.getSchemaByName)(schemas, agg.schema), [agg.schema, schemas]);
  const aggFilter = (0, _react.useMemo)(() => [...allowedAggs, ...(schema.aggFilter || [])], [allowedAggs, schema.aggFilter]);
  const {
    services
  } = (0, _public2.useKibana)();
  const aggTypes = (0, _react.useMemo)(() => services.data.search.aggs.types.getAll(), [services.data.search.aggs.types]);
  const groupedAggTypeOptions = (0, _react.useMemo)(() => (0, _agg_params_helper.getAggTypeOptions)(aggTypes, agg, indexPattern, groupName, aggFilter), [aggTypes, agg, indexPattern, groupName, aggFilter]);
  const error = aggIsTooLow ? _i18n.i18n.translate('visDefaultEditor.aggParams.errors.aggWrongRunOrderErrorMessage', {
    defaultMessage: '"{schema}" aggs must run before all other buckets!',
    values: {
      schema: schema.title
    }
  }) : '';
  const aggTypeName = (_agg$type = agg.type) === null || _agg$type === void 0 ? void 0 : _agg$type.name;
  const fieldName = (_agg$params = agg.params) === null || _agg$params === void 0 ? void 0 : (_agg$params$field = _agg$params.field) === null || _agg$params$field === void 0 ? void 0 : _agg$params$field.name;
  const editorConfig = (0, _react.useMemo)(() => (0, _utils.getEditorConfig)(indexPattern, aggTypeName, fieldName), [indexPattern, aggTypeName, fieldName]);
  const params = (0, _react.useMemo)(() => (0, _agg_params_helper.getAggParamsToRender)({
    agg,
    editorConfig,
    metricAggs,
    state,
    schemas,
    hideCustomLabel
  }), [agg, editorConfig, metricAggs, state, schemas, hideCustomLabel]);
  const allParams = [...params.basic, ...params.advanced];
  const [paramsState, onChangeParamsState] = (0, _react.useReducer)(_agg_params_state.aggParamsReducer, allParams, _agg_params_state.initAggParamsState);
  const [aggType, onChangeAggType] = (0, _react.useReducer)(_agg_params_state.aggTypeReducer, {
    touched: false,
    valid: true
  });
  const isFormValid = !error && aggType.valid && Object.entries(paramsState).every(([, paramState]) => paramState.valid);
  const isAllInvalidParamsTouched = !!error || (0, _agg_params_helper.isInvalidParamsTouched)(agg.type, aggType, paramsState);
  const onAggSelect = (0, _react.useCallback)(value => {
    if (agg.type !== value) {
      onAggTypeChange(agg.id, value);
      // reset touched and valid of params
      onChangeParamsState({
        type: _agg_params_state.AGG_PARAMS_ACTION_KEYS.RESET
      });
    }
  }, [onAggTypeChange, agg]);

  // reset validity before component destroyed
  (0, _useUnmount.default)(() => setValidity(true));
  (0, _react.useEffect)(() => {
    Object.entries(editorConfig).forEach(([param, paramConfig]) => {
      const paramOptions = agg.type.params.find(paramOption => paramOption.name === param);
      const hasFixedValue = Object.hasOwn(paramConfig, FIXED_VALUE_PROP);
      const hasDefault = Object.hasOwn(paramConfig, DEFAULT_PROP);
      // If the parameter has a fixed value in the config, set this value.
      // Also for all supported configs we should freeze the editor for this param.
      if (hasFixedValue || hasDefault) {
        let newValue;
        let property = FIXED_VALUE_PROP;
        let typedParamConfig = paramConfig;
        if (hasDefault) {
          property = DEFAULT_PROP;
          typedParamConfig = paramConfig;
        }
        if (paramOptions && paramOptions.deserialize) {
          newValue = paramOptions.deserialize(typedParamConfig[property]);
        } else {
          newValue = typedParamConfig[property];
        }

        // this check is obligatory to avoid infinite render, because setAggParamValue creates a brand new agg object
        if (agg.params[param] !== newValue) {
          setAggParamValue(agg.id, param, newValue);
        }
      }
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [editorConfig]);
  (0, _react.useEffect)(() => {
    setTouched(false);
  }, [agg.type, setTouched]);
  (0, _react.useEffect)(() => {
    setValidity(isFormValid);
  }, [isFormValid, agg.type, setValidity]);
  (0, _react.useEffect)(() => {
    // when all invalid controls were touched or they are untouched
    setTouched(isAllInvalidParamsTouched);
  }, [isAllInvalidParamsTouched, setTouched]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    className: className,
    isInvalid: !!error,
    error: error,
    "data-test-subj": "visAggEditorParams",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_agg_select.DefaultEditorAggSelect, {
    aggError: aggError,
    id: agg.id,
    indexPattern: indexPattern,
    value: agg.type,
    aggTypeOptions: groupedAggTypeOptions,
    isSubAggregation: aggIndex >= 1 && groupName === _public.AggGroupNames.Buckets,
    showValidation: formIsTouched || aggType.touched,
    setValue: onAggSelect,
    onChangeAggType: onChangeAggType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }), params.basic.map(param => {
    const model = paramsState[param.aggParam.name] || {
      touched: false,
      valid: true
    };
    return /*#__PURE__*/_react.default.createElement(_agg_param.DefaultEditorAggParam, (0, _extends2.default)({
      key: `${param.aggParam.name}${agg.type ? agg.type.name : ''}`,
      disabled: disabledParams && disabledParams.includes(param.aggParam.name),
      formIsTouched: formIsTouched,
      showValidation: formIsTouched || model.touched,
      setAggParamValue: setAggParamValue,
      onChangeParamsState: onChangeParamsState
    }, param, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 11
      }
    }));
  }), params.advanced.length ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "advancedAccordion",
    "data-test-subj": `advancedParams-${agg.id}`,
    buttonContent: _i18n.i18n.translate('visDefaultEditor.advancedToggle.advancedLinkLabel', {
      defaultMessage: 'Advanced'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 13
    }
  }), params.advanced.map(param => {
    const model = paramsState[param.aggParam.name] || {
      touched: false,
      valid: true
    };
    return /*#__PURE__*/_react.default.createElement(_agg_param.DefaultEditorAggParam, (0, _extends2.default)({
      key: `${param.aggParam.name}${agg.type ? agg.type.name : ''}`,
      disabled: disabledParams && disabledParams.includes(param.aggParam.name),
      formIsTouched: formIsTouched,
      showValidation: formIsTouched || model.touched,
      setAggParamValue: setAggParamValue,
      onChangeParamsState: onChangeParamsState
    }, param, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 17
      }
    }));
  }))) : null);
}