"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visEditorSidebarStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const visEditorSidebarStyles = exports.visEditorSidebarStyles = {
  section: ({
    euiTheme
  }) => (0, _react.css)({
    backgroundColor: euiTheme.colors.emptyShade,
    padding: euiTheme.size.s,
    borderRadius: euiTheme.border.radius.medium,
    '+ .visEditorSidebar__section': {
      marginTop: euiTheme.size.s
    }
  }),
  collapsible: ({
    euiTheme,
    colorMode
  }) => (0, _react.css)({
    backgroundColor: colorMode === _eui.COLOR_MODES_STANDARD.light ? euiTheme.colors.backgroundBaseSubdued : euiTheme.colors.backgroundBaseFormsPrepend
  }),
  collapsibleMarginBottom: ({
    euiTheme
  }) => (0, _react.css)({
    marginBottom: euiTheme.size.m
  }),
  aggGroupAccordionButtonContent: euiThemeContext => (0, _react.css)({
    '.visEditorSidebar__aggGroupAccordionButtonContent': {
      fontSize: (0, _eui.euiFontSize)(euiThemeContext, 's').fontSize,
      span: {
        color: euiThemeContext.euiTheme.colors.darkShade
      }
    }
  })
};