"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.longTaskMetricsQuery = longTaskMetricsQuery;
var _merge_projection = require("../../../common/utils/merge_projection");
var _core_web_vitals_query = require("./core_web_vitals_query");
var _projections = require("./projections");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LONG_TASK_SUM_FIELD = 'transaction.experience.longtask.sum';
const LONG_TASK_COUNT_FIELD = 'transaction.experience.longtask.count';
const LONG_TASK_MAX_FIELD = 'transaction.experience.longtask.max';
function longTaskMetricsQuery(start, end, percentile = _core_web_vitals_query.PERCENTILE_DEFAULT, urlQuery, uiFilters) {
  const setup = {
    uiFilters: uiFilters ? uiFilters : {}
  };
  const projection = (0, _projections.getRumPageLoadTransactionsProjection)({
    setup,
    urlQuery,
    start,
    end
  });
  const params = (0, _merge_projection.mergeProjection)(projection, {
    size: 0,
    aggs: {
      longTaskSum: {
        percentiles: {
          field: LONG_TASK_SUM_FIELD,
          percents: [percentile],
          hdr: {
            number_of_significant_value_digits: 3
          }
        }
      },
      longTaskCount: {
        percentiles: {
          field: LONG_TASK_COUNT_FIELD,
          percents: [percentile],
          hdr: {
            number_of_significant_value_digits: 3
          }
        }
      },
      longTaskMax: {
        percentiles: {
          field: LONG_TASK_MAX_FIELD,
          percents: [percentile],
          hdr: {
            number_of_significant_value_digits: 3
          }
        }
      }
    }
  });
  return params;
}