"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatHasRumResult = formatHasRumResult;
exports.hasRumDataQuery = hasRumDataQuery;
var _moment = _interopRequireDefault(require("moment"));
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _transaction_types = require("../../../common/transaction_types");
var _range_query = require("./range_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function formatHasRumResult(esResult, indices) {
  var _esResult$aggregation, _esResult$aggregation2, _esResult$aggregation3, _esResult$aggregation4, _esResult$aggregation5;
  if (!esResult) return esResult;
  return {
    indices,
    hasData: esResult.hits.total.value > 0,
    serviceName: (_esResult$aggregation = esResult.aggregations) === null || _esResult$aggregation === void 0 ? void 0 : (_esResult$aggregation2 = _esResult$aggregation.services) === null || _esResult$aggregation2 === void 0 ? void 0 : (_esResult$aggregation3 = _esResult$aggregation2.mostTraffic) === null || _esResult$aggregation3 === void 0 ? void 0 : (_esResult$aggregation4 = _esResult$aggregation3.buckets) === null || _esResult$aggregation4 === void 0 ? void 0 : (_esResult$aggregation5 = _esResult$aggregation4[0]) === null || _esResult$aggregation5 === void 0 ? void 0 : _esResult$aggregation5.key
  };
}
function hasRumDataQuery({
  start = (0, _moment.default)().subtract(24, 'h').valueOf(),
  end = (0, _moment.default)().valueOf()
}) {
  return {
    size: 0,
    query: {
      bool: {
        filter: [{
          term: {
            [_elasticsearch_fieldnames.TRANSACTION_TYPE]: _transaction_types.TRANSACTION_PAGE_LOAD
          }
        }, {
          term: {
            [_elasticsearch_fieldnames.PROCESSOR_EVENT]: 'transaction'
          }
        }]
      }
    },
    aggs: {
      services: {
        filter: (0, _range_query.rangeQuery)(start, end)[0],
        aggs: {
          mostTraffic: {
            terms: {
              field: _elasticsearch_fieldnames.SERVICE_NAME,
              size: 1
            }
          }
        }
      }
    }
  };
}