"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getEnvironments = getEnvironments;
exports.transformEnvironmentsResponse = transformEnvironmentsResponse;
var _transaction_types = require("../../../common/transaction_types");
var _elasticsearch_fieldnames = require("../../../common/elasticsearch_fieldnames");
var _environment_filter_values = require("../../../common/environment_filter_values");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformEnvironmentsResponse(response) {
  if (!response) return response;
  const aggs = response.aggregations;
  const environmentsBuckets = (aggs === null || aggs === void 0 ? void 0 : aggs.environments.buckets) || [];
  const environments = environmentsBuckets.map(environmentBucket => environmentBucket.key);
  return environments;
}
function getEnvironments({
  serviceName,
  size,
  start,
  end
}) {
  return {
    size: 0,
    query: {
      bool: {
        filter: [{
          range: {
            '@timestamp': {
              gte: start,
              lte: end,
              format: 'epoch_millis'
            }
          }
        }, {
          term: {
            [_elasticsearch_fieldnames.TRANSACTION_TYPE]: _transaction_types.TRANSACTION_PAGE_LOAD
          }
        }, {
          term: {
            [_elasticsearch_fieldnames.PROCESSOR_EVENT]: 'transaction'
          }
        }, ...(serviceName === undefined || serviceName === null ? [] : [{
          term: {
            [_elasticsearch_fieldnames.SERVICE_NAME]: serviceName
          }
        }])]
      }
    },
    aggs: {
      environments: {
        terms: {
          field: _elasticsearch_fieldnames.SERVICE_ENVIRONMENT,
          missing: _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value,
          size
        }
      }
    }
  };
}