"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapToolTip = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_layer_list = require("./use_layer_list");
var _translations = require("../translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/visitor_breakdown_map/map_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DescriptionItem = (0, _styled.default)(_eui.EuiDescriptionListDescription)`
  &&& {
    width: 25%;
  }
`;
const TitleItem = (0, _styled.default)(_eui.EuiDescriptionListTitle)`
  &&& {
    width: 75%;
  }
`;
const formatPageLoadValue = val => {
  const valInMs = val / 1000;
  if (valInMs > 1000) {
    return (valInMs / 1000).toFixed(2) + ' sec';
  }
  return (valInMs / 1000).toFixed(0) + ' ms';
};
function MapToolTipComponent({
  closeTooltip,
  features = [],
  loadFeatureProperties
}) {
  var _features$;
  const {
    id: featureId,
    layerId,
    mbProperties
  } = (_features$ = features[0]) !== null && _features$ !== void 0 ? _features$ : {};
  const [regionName, setRegionName] = (0, _react.useState)(featureId);
  const [pageLoadDuration, setPageLoadDuration] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const loadRegionInfo = async () => {
      if (loadFeatureProperties) {
        const items = await loadFeatureProperties({
          layerId,
          properties: mbProperties
        });
        items.forEach(item => {
          if (item.getPropertyKey() === _use_layer_list.COUNTRY_NAME || item.getPropertyKey() === _use_layer_list.REGION_NAME) {
            setRegionName(item.getRawValue());
          }
          if (item.getPropertyKey() === _use_layer_list.TRANSACTION_DURATION_REGION || item.getPropertyKey() === _use_layer_list.TRANSACTION_DURATION_COUNTRY) {
            setPageLoadDuration(formatPageLoadValue(+item.getRawValue()));
          }
        });
      }
    };
    loadRegionInfo();
  }, [layerId, loadFeatureProperties, mbProperties]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOutsideClickDetector, {
    onOutsideClick: () => {
      if (closeTooltip != null) {
        closeTooltip();
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, regionName), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    textStyle: "reverse",
    compressed: true,
    style: {
      width: 300
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(TitleItem, {
    className: "eui-textNoWrap",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, _translations.I18LABELS.avgPageLoadDuration), /*#__PURE__*/_react.default.createElement(DescriptionItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, pageLoadDuration))));
}
const MapToolTip = exports.MapToolTip = /*#__PURE__*/_react.default.memo(MapToolTipComponent);