"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisitorBreakdown = VisitorBreakdown;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _ux_ui_filter = require("../../../../../common/ux_ui_filter");
var _visitor_breakdown_chart = require("../charts/visitor_breakdown_chart");
var _translations = require("../translations");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _use_local_uifilters = require("../hooks/use_local_uifilters");
var _local_uifilters = require("../local_uifilters");
var _use_data_view = require("../local_uifilters/use_data_view");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/visitor_breakdown/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const visitorBreakdownFieldMap = {
  [_visitor_breakdown_chart.VisitorBreakdownMetric.OS_BREAKDOWN]: 'os',
  [_visitor_breakdown_chart.VisitorBreakdownMetric.UA_BREAKDOWN]: 'browser'
};
const EuiLoadingEmbeddable = (0, _styled.default)(_eui.EuiFlexGroup)`
  & {
    min-height: 100%;
    min-width: 100%;
  }
`;
const vistorBreakdownFilter = {
  filterNames: _ux_ui_filter.uxLocalUIFilterNames.filter(name => ['browser', 'browserExcluded', 'os', 'osExcluded'].includes(name))
};
const getInvertedFilterName = (filter, negate) => negate ? filter : (0, _local_uifilters.getExcludedName)(filter);
function VisitorBreakdown() {
  const {
    urlParams,
    uxUiFilters
  } = (0, _use_url_params.useLegacyUrlParams)();
  const {
    start,
    end,
    searchTerm
  } = urlParams;
  const {
    dataView
  } = (0, _use_data_view.useDataView)();
  const {
    filters,
    setFilterValue
  } = (0, _use_local_uifilters.useLocalUIFilters)(vistorBreakdownFilter);
  const onFilter = (0, _react.useCallback)((metric, event) => {
    var _event$data, _event$negate, _filters$find$value, _filters$find;
    if (!visitorBreakdownFieldMap[metric]) {
      return;
    }
    const filterValues = event === null || event === void 0 ? void 0 : (_event$data = event.data) === null || _event$data === void 0 ? void 0 : _event$data.map(fdata => fdata.value);
    const invertedField = getInvertedFilterName(visitorBreakdownFieldMap[metric], (_event$negate = event === null || event === void 0 ? void 0 : event.negate) !== null && _event$negate !== void 0 ? _event$negate : false);
    const invertedFieldValues = (_filters$find$value = filters === null || filters === void 0 ? void 0 : (_filters$find = filters.find(filter => filter.name === invertedField)) === null || _filters$find === void 0 ? void 0 : _filters$find.value) !== null && _filters$find$value !== void 0 ? _filters$find$value : [];
    setFilterValue(invertedField, invertedFieldValues.filter(value => !filterValues.includes(value)));
    setFilterValue(event !== null && event !== void 0 && event.negate ? (0, _local_uifilters.getExcludedName)(visitorBreakdownFieldMap[metric]) : visitorBreakdownFieldMap[metric], filterValues);
  }, [filters, setFilterValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, _translations.VisitorBreakdownLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      height: 'calc(100% - 32px)'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, _translations.I18LABELS.browser)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }), !(dataView !== null && dataView !== void 0 && dataView.id) ? /*#__PURE__*/_react.default.createElement(EuiLoadingEmbeddable, {
    justifyContent: "spaceAround",
    alignItems: 'center',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }))) : /*#__PURE__*/_react.default.createElement(_visitor_breakdown_chart.VisitorBreakdownChart, {
    dataView: dataView,
    start: start !== null && start !== void 0 ? start : '',
    end: end !== null && end !== void 0 ? end : '',
    uiFilters: uxUiFilters,
    urlQuery: searchTerm,
    metric: _visitor_breakdown_chart.VisitorBreakdownMetric.UA_BREAKDOWN,
    onFilter: onFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, _translations.I18LABELS.operatingSystem)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 11
    }
  }), !(dataView !== null && dataView !== void 0 && dataView.id) ? /*#__PURE__*/_react.default.createElement(EuiLoadingEmbeddable, {
    justifyContent: "spaceAround",
    alignItems: 'center',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }))) : /*#__PURE__*/_react.default.createElement(_visitor_breakdown_chart.VisitorBreakdownChart, {
    dataView: dataView,
    start: start !== null && start !== void 0 ? start : '',
    end: end !== null && end !== void 0 ? end : '',
    uiFilters: uxUiFilters,
    urlQuery: searchTerm,
    metric: _visitor_breakdown_chart.VisitorBreakdownMetric.OS_BREAKDOWN,
    onFilter: onFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 13
    }
  }))));
}