"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UXMetrics = UXMetrics;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-plugin/public");
var _use_inp_query = require("../../../../hooks/use_inp_query");
var _translations = require("../translations");
var _key_ux_metrics = require("./key_ux_metrics");
var _use_ux_query = require("../hooks/use_ux_query");
var _csm_shared_context = require("../csm_shared_context");
var _use_url_params = require("../../../../context/url_params_context/use_url_params");
var _translations2 = require("./translations");
var _use_core_web_vitals_query = require("../../../../hooks/use_core_web_vitals_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/ux_metrics/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function UXMetrics() {
  const {
    urlParams: {
      percentile
    }
  } = (0, _use_url_params.useLegacyUrlParams)();
  const uxQuery = (0, _use_ux_query.useUxQuery)();
  const {
    data,
    loading: loadingResponse
  } = (0, _use_core_web_vitals_query.useCoreWebVitalsQuery)(uxQuery);
  const {
    data: inpData,
    loading: inpLoading
  } = (0, _use_inp_query.useINPQuery)(uxQuery);
  const loading = (loadingResponse !== null && loadingResponse !== void 0 ? loadingResponse : true) || inpLoading;
  const {
    sharedData: {
      totalPageViews
    }
  } = (0, _react.useContext)(_csm_shared_context.CsmSharedContext);
  const CoreVitals = (0, _react.useMemo)(() => (0, _public.getCoreVitalsComponent)({
    data: {
      ...data,
      inp: inpData === null || inpData === void 0 ? void 0 : inpData.inp,
      inpRanks: inpData === null || inpData === void 0 ? void 0 : inpData.inpRanks,
      hasINP: inpData === null || inpData === void 0 ? void 0 : inpData.hasINP
    },
    totalPageViews,
    loading,
    displayTrafficMetric: true
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [loading, inpLoading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    wrap: true,
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-cy": `client-metrics`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  }, _translations.I18LABELS.metrics, " (", (0, _translations2.getPercentileLabel)(percentile), ")")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_key_ux_metrics.KeyUXMetrics, {
    data: data,
    loading: loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    "data-cy": `client-metrics`,
    style: {
      minHeight: 150
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }), CoreVitals)));
}