"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PercentileAnnotations = PercentileAnnotations;
var React = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _uiTheme = require("@kbn/ui-theme");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/page_load_distribution/percentile_annotations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function generateAnnotationData(values) {
  return Object.entries(values !== null && values !== void 0 ? values : {}).map(value => ({
    dataValue: value[1],
    details: `${(+value[0]).toFixed(0)}`
  }));
}
function PercentileAnnotations({
  percentiles
}) {
  var _generateAnnotationDa;
  const dataValues = (_generateAnnotationDa = generateAnnotationData(percentiles)) !== null && _generateAnnotationDa !== void 0 ? _generateAnnotationDa : [];
  const style = {
    line: {
      strokeWidth: 1,
      stroke: _uiTheme.euiLightVars.euiColorSuccess,
      opacity: 1
    }
  };
  function PercentileTooltip({
    annotation
  }) {
    return /*#__PURE__*/React.createElement("span", {
      "data-cy": "percentileTooltipTitle",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 12
      }
    }, annotation.details, "th Percentile");
  }
  return /*#__PURE__*/React.createElement(React.Fragment, null, dataValues.map((annotation, index) => /*#__PURE__*/React.createElement(_charts.LineAnnotation, {
    id: index + 'annotation_' + annotation.dataValue,
    key: index + 'percentile_' + annotation.dataValue,
    domainType: _charts.AnnotationDomainType.XDomain,
    dataValues: [annotation],
    style: style,
    hideTooltips: true,
    markerPosition: _charts.Position.Top,
    marker: /*#__PURE__*/React.createElement("span", {
      "data-cy": "percentile-markers",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, /*#__PURE__*/React.createElement(_eui.EuiToolTip, {
      title: /*#__PURE__*/React.createElement(PercentileTooltip, {
        annotation: annotation,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 24
        }
      }),
      content: /*#__PURE__*/React.createElement("span", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 26
        }
      }, "Pages loaded: ", Math.round(annotation.dataValue)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 15
      }
    }, /*#__PURE__*/React.createElement(React.Fragment, null, annotation.details, "th"))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  })));
}