"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Metrics = Metrics;
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _use_client_metrics_query = require("../../../../hooks/use_client_metrics_query");
var _translations = require("../translations");
var _key_ux_metrics = require("../ux_metrics/key_ux_metrics");
var _csm_shared_context = require("../csm_shared_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/client_metrics/metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ClFlexGroup = (0, _styled.default)(_eui.EuiFlexGroup)`
  flex-direction: row;
  @media only screen and (max-width: 768px) {
    flex-direction: row;
    justify-content: space-between;
  }
`;
function formatTitle(unit, value) {
  if (typeof value === 'undefined') return _translations.I18LABELS.dataMissing;
  return (0, _key_ux_metrics.formatToSec)(value, unit);
}
function PageViewsTotalTitle({
  pageViews
}) {
  if (typeof pageViews === 'undefined') {
    return /*#__PURE__*/React.createElement(React.Fragment, null, _translations.I18LABELS.dataMissing);
  }
  return pageViews < 10000 ? /*#__PURE__*/React.createElement(React.Fragment, null, (0, _numeral.default)(pageViews).format('0,0')) : /*#__PURE__*/React.createElement(_eui.EuiToolTip, {
    content: (0, _numeral.default)(pageViews).format('0,0'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }, /*#__PURE__*/React.createElement("span", {
    tabIndex: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, (0, _numeral.default)(pageViews).format('0 a')));
}
function Metrics() {
  var _data$totalPageLoadDu, _data$backEnd, _data$frontEnd, _data$pageViews2;
  const {
    data,
    loading
  } = (0, _use_client_metrics_query.useClientMetricsQuery)();
  const {
    setSharedData
  } = (0, _react.useContext)(_csm_shared_context.CsmSharedContext);
  (0, _react.useEffect)(() => {
    var _data$pageViews$value, _data$pageViews;
    setSharedData({
      totalPageViews: (_data$pageViews$value = data === null || data === void 0 ? void 0 : (_data$pageViews = data.pageViews) === null || _data$pageViews === void 0 ? void 0 : _data$pageViews.value) !== null && _data$pageViews$value !== void 0 ? _data$pageViews$value : 0
    });
  }, [data, setSharedData]);
  const STAT_STYLE = {
    minWidth: '150px',
    maxWidth: '250px'
  };
  return /*#__PURE__*/React.createElement(ClFlexGroup, {
    wrap: true,
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: STAT_STYLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxClientMetrics-totalPageLoad',
    titleSize: "l",
    title: formatTitle('ms', data === null || data === void 0 ? void 0 : (_data$totalPageLoadDu = data.totalPageLoadDuration) === null || _data$totalPageLoadDu === void 0 ? void 0 : _data$totalPageLoadDu.value),
    description: /*#__PURE__*/React.createElement(React.Fragment, null, _translations.I18LABELS.totalPageLoad, /*#__PURE__*/React.createElement(_eui.EuiIconTip, {
      content: _translations.I18LABELS.totalPageLoadTooltip,
      type: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 15
      }
    })),
    isLoading: !!loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: STAT_STYLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxClientMetrics-backend',
    titleSize: "l",
    title: formatTitle('ms', data === null || data === void 0 ? void 0 : (_data$backEnd = data.backEnd) === null || _data$backEnd === void 0 ? void 0 : _data$backEnd.value),
    description: /*#__PURE__*/React.createElement(React.Fragment, null, _translations.I18LABELS.backEnd, /*#__PURE__*/React.createElement(_eui.EuiIconTip, {
      content: _translations.I18LABELS.backEndTooltip,
      type: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 15
      }
    })),
    isLoading: !!loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: STAT_STYLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxClientMetrics-frontend',
    titleSize: "l",
    title: formatTitle('ms', data === null || data === void 0 ? void 0 : (_data$frontEnd = data.frontEnd) === null || _data$frontEnd === void 0 ? void 0 : _data$frontEnd.value),
    description: /*#__PURE__*/React.createElement(React.Fragment, null, _translations.I18LABELS.frontEnd, /*#__PURE__*/React.createElement(_eui.EuiIconTip, {
      content: _translations.I18LABELS.frontEndTooltip,
      type: "question",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 15
      }
    })),
    isLoading: !!loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  })), /*#__PURE__*/React.createElement(_eui.EuiFlexItem, {
    style: STAT_STYLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/React.createElement(_eui.EuiStat, {
    "data-test-subj": 'uxClientMetrics-pageViews',
    titleSize: "l",
    title: /*#__PURE__*/React.createElement(PageViewsTotalTitle, {
      pageViews: data === null || data === void 0 ? void 0 : (_data$pageViews2 = data.pageViews) === null || _data$pageViews2 === void 0 ? void 0 : _data$pageViews2.value,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 18
      }
    }),
    description: _translations.I18LABELS.pageViews,
    isLoading: !!loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  })));
}