"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisitorBreakdownChart = VisitorBreakdownChart;
exports.VisitorBreakdownMetric = void 0;
exports.getVisitorBreakdownLensAttributes = getVisitorBreakdownLensAttributes;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/observability-plugin/common");
var _uuid = require("uuid");
var _transaction_types = require("../../../../../common/transaction_types");
var _elasticsearch_fieldnames = require("../../../../../common/elasticsearch_fieldnames");
var _get_es_filter = require("../../../../services/data/get_es_filter");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/charts/visitor_breakdown_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BUCKET_SIZE = 9;
let VisitorBreakdownMetric = exports.VisitorBreakdownMetric = /*#__PURE__*/function (VisitorBreakdownMetric) {
  VisitorBreakdownMetric["OS_BREAKDOWN"] = "user_agent.os.name";
  VisitorBreakdownMetric["UA_BREAKDOWN"] = "user_agent.name";
  return VisitorBreakdownMetric;
}({});
function VisitorBreakdownChart({
  start,
  end,
  onFilter,
  uiFilters,
  urlQuery,
  metric,
  dataView
}) {
  const kibana = (0, _use_kibana_services.useKibanaServices)();
  const LensEmbeddableComponent = kibana.lens.EmbeddableComponent;
  const [localDataViewId] = (0, _react.useState)((0, _uuid.v4)());
  const lensAttributes = (0, _react.useMemo)(() => getVisitorBreakdownLensAttributes({
    uiFilters,
    urlQuery,
    metric,
    dataView,
    localDataViewId
  }), [uiFilters, urlQuery, metric, dataView, localDataViewId]);
  const filterHandler = (0, _react.useCallback)(event => {
    onFilter(metric, event);
  }, [onFilter, metric]);
  if (!LensEmbeddableComponent) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.ux.visitorBreakdownChart.noLensComponentTextLabel', {
      defaultMessage: 'No lens component'
    }));
  }
  return /*#__PURE__*/_react.default.createElement(LensEmbeddableComponent, {
    id: `ux-visitor-breakdown-${metric.replaceAll('.', '-')}`,
    hidePanelTitles: true,
    withDefaultActions: true,
    style: {
      minHeight: '250px',
      height: '100%'
    },
    attributes: lensAttributes,
    timeRange: {
      from: start !== null && start !== void 0 ? start : '',
      to: end !== null && end !== void 0 ? end : ''
    },
    viewMode: 'view',
    onFilter: filterHandler,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  });
}
const visConfig = {
  layers: [{
    layerId: 'layer1',
    primaryGroups: ['col1'],
    metrics: ['col2'],
    categoryDisplay: 'default',
    legendDisplay: 'hide',
    numberDisplay: 'percent',
    legendStats: ['value'],
    nestedLegend: false,
    layerType: 'data'
  }],
  shape: 'pie'
};
function getVisitorBreakdownLensAttributes({
  uiFilters,
  urlQuery,
  metric,
  dataView,
  localDataViewId
}) {
  const localDataView = dataView.toSpec(false);
  localDataView.id = localDataViewId;
  const dataLayer = {
    incompleteColumns: {},
    columnOrder: ['col1', 'col2'],
    columns: {
      col1: {
        label: `Top ${BUCKET_SIZE} values of ${metric}`,
        dataType: 'string',
        operationType: 'terms',
        scale: 'ordinal',
        sourceField: metric,
        isBucketed: true,
        params: {
          size: BUCKET_SIZE,
          orderBy: {
            type: 'column',
            columnId: 'col2'
          },
          orderDirection: 'desc',
          otherBucket: true,
          parentFormat: {
            id: 'terms'
          }
        }
      },
      col2: {
        label: 'Count of records',
        dataType: 'number',
        operationType: 'count',
        isBucketed: false,
        scale: 'ratio',
        sourceField: '___records___',
        params: {
          emptyAsNull: true
        }
      }
    }
  };
  return {
    visualizationType: 'lnsPie',
    title: `ux-visitor-breakdown-${metric}`,
    references: [],
    state: {
      internalReferences: [{
        id: localDataView.id,
        name: 'indexpattern-datasource-current-indexpattern',
        type: 'index-pattern'
      }, {
        id: localDataView.id,
        name: 'indexpattern-datasource-layer-layer1',
        type: 'index-pattern'
      }],
      adHocDataViews: {
        [localDataView.id]: localDataView
      },
      datasourceStates: {
        formBased: {
          layers: {
            layer1: dataLayer
          }
        }
      },
      filters: [{
        meta: {},
        query: {
          bool: {
            filter: [{
              term: {
                [_elasticsearch_fieldnames.TRANSACTION_TYPE]: _transaction_types.TRANSACTION_PAGE_LOAD
              }
            }, {
              terms: {
                [_elasticsearch_fieldnames.PROCESSOR_EVENT]: [_common.ProcessorEvent.transaction]
              }
            }, {
              exists: {
                field: 'transaction.marks.navigationTiming.fetchStart'
              }
            }, ...(0, _get_es_filter.getEsFilter)(uiFilters), ...(urlQuery ? [{
              wildcard: {
                'url.full': `*${urlQuery}*`
              }
            }] : [])],
            must_not: [...(0, _get_es_filter.getEsFilter)(uiFilters, true)]
          }
        }
      }],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization: visConfig
    }
  };
}