"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UxInspectorHeaderLink = UxInspectorHeaderLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _use_kibana_services = require("../../../../hooks/use_kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/components/app/rum_dashboard/action_menu/inpector_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function UxInspectorHeaderLink({
  isDev
}) {
  const {
    inspectorAdapters
  } = (0, _public2.useInspectorContext)();
  const {
    uiSettings,
    inspector
  } = (0, _use_kibana_services.useKibanaServices)();
  const isInspectorEnabled = uiSettings.get(_public.enableInspectEsQueries);
  const inspect = () => {
    inspector.open(inspectorAdapters);
  };
  if (!isInspectorEnabled && !isDev) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderLink, {
    color: "primary",
    onClick: inspect,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.ux.inspectButtonText', {
    defaultMessage: 'Inspect'
  }));
}