"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UXAppRoot = UXAppRoot;
exports.uxRoutes = exports.uxRouter = exports.renderApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public3 = require("@kbn/observability-plugin/public");
var _public4 = require("@kbn/observability-shared-plugin/public");
var _csm_shared_context = require("../components/app/rum_dashboard/csm_shared_context");
var _rum_home = require("../components/app/rum_dashboard/rum_home");
var _action_menu = require("../components/app/rum_dashboard/action_menu");
var _url_params_context = require("../context/url_params_context/url_params_context");
var _data_view = require("../services/rest/data_view");
var _create_call_apm_api = require("../services/rest/create_call_apm_api");
var _use_kibana_services = require("../hooks/use_kibana_services");
var _plugin_context = require("../context/plugin_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/ux/public/application/ux_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const uxRoutes = exports.uxRoutes = [{
  exact: true,
  path: '/',
  render: () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: "/ux",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 19
    }
  }),
  breadcrumb: _rum_home.DASHBOARD_LABEL
}];
function UxApp() {
  const {
    http
  } = (0, _use_kibana_services.useKibanaServices)();
  const basePath = http.basePath.get();
  (0, _public4.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.ux.breadcrumbs.root', {
      defaultMessage: 'User Experience'
    }),
    href: basePath + '/app/ux'
  }, {
    text: _i18n.i18n.translate('xpack.ux.breadcrumbs.dashboard', {
      defaultMessage: 'Dashboard'
    })
  }]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": "csmMainContainer",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_rum_home.RumHome, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
}
const uxRouter = exports.uxRouter = (0, _typedReactRouterConfig.createRouter)({});
function UXAppRoot({
  appMountParameters,
  core,
  deps,
  corePlugins: {
    embeddable,
    inspector,
    maps,
    observability,
    observabilityShared,
    observabilityAIAssistant,
    exploratoryView,
    data,
    dataViews,
    lens
  },
  isDev,
  spaceId
}) {
  const {
    history
  } = appMountParameters;
  const plugins = {
    ...deps,
    maps
  };
  (0, _create_call_apm_api.createCallApmApi)(core);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: core.application
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      inspector,
      observability,
      observabilityShared,
      observabilityAIAssistant,
      embeddable,
      exploratoryView,
      data,
      dataViews,
      lens
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: core.theme,
    modify: {
      breakpoint: {
        xxl: 1600,
        xxxl: 2000
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      appMountParameters,
      exploratoryView,
      observabilityShared,
      spaceId
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: uxRouter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_public3.DatePickerContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_public4.InspectorContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_url_params_context.UrlParamsProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_csm_shared_context.CsmSharedContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(UxApp, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 27
    }
  })), /*#__PURE__*/_react.default.createElement(_action_menu.UXActionMenu, {
    appMountParameters: appMountParameters,
    isDev: isDev,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 25
    }
  })))))))))));
}

/**
 * This module is rendered asynchronously in the Kibana platform.
 */

const renderApp = ({
  core,
  deps,
  appMountParameters,
  corePlugins,
  isDev,
  spaceId
}) => {
  const {
    element
  } = appMountParameters;
  (0, _create_call_apm_api.createCallApmApi)(core);

  // Automatically creates static data view and stores as saved object
  (0, _data_view.createStaticDataView)().catch(e => {
    // eslint-disable-next-line no-console
    console.log('Error creating static data view', e);
  });
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(UXAppRoot, {
    appMountParameters: appMountParameters,
    core: core,
    deps: deps,
    corePlugins: corePlugins,
    isDev: isDev,
    spaceId: spaceId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 5
    }
  }), element);
  return () => {
    corePlugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;