"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateUserProfile = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _i18n = require("@kbn/i18n");
var _services = require("../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/src/platform/packages/shared/kbn-user-profile-components/src/hooks/use_update_user_profile.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  notificationSuccess: {
    title: _i18n.i18n.translate('userProfileComponents.updateUserProfile.notification.submitSuccessTitle', {
      defaultMessage: 'Profile updated'
    }),
    pageReloadText: _i18n.i18n.translate('userProfileComponents.updateUserProfile.notification.requiresPageReloadDescription', {
      defaultMessage: 'One or more settings require you to reload the page to take effect.'
    })
  }
};
const useUpdateUserProfile = ({
  notificationSuccess = {},
  pageReloadChecker
} = {}) => {
  const {
    userProfileApiClient,
    notifySuccess
  } = (0, _services.useUserProfiles)();
  const {
    userProfile$,
    enabled$,
    userProfileLoaded$
  } = userProfileApiClient;
  const {
    enabled: notificationSuccessEnabled = true,
    title: notificationTitle = i18nTexts.notificationSuccess.title,
    pageReloadText = i18nTexts.notificationSuccess.pageReloadText
  } = notificationSuccess;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const userProfileData = (0, _useObservable.default)(userProfile$);
  const userProfileEnabled = (0, _useObservable.default)(enabled$);
  const userProfileLoaded = (0, _useObservable.default)(userProfileLoaded$, false);
  // Keep a snapshot before updating the user profile so we can compare previous and updated values
  const userProfileSnapshot = (0, _react.useRef)();
  const isMounted = (0, _react.useRef)(false);
  const showSuccessNotification = (0, _react.useCallback)(({
    isRefreshRequired = false
  } = {}) => {
    if (isRefreshRequired) {
      notifySuccess({
        title: notificationTitle,
        text: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 17
          }
        }, pageReloadText), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          justifyContent: "flexEnd",
          gutterSize: "s",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 81,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 82,
            columnNumber: 19
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
          size: "s",
          onClick: () => window.location.reload(),
          "data-test-subj": "windowReloadButton",
          autoFocus: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 83,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('userProfileComponents.updateUserProfile.notification.requiresPageReloadButtonLabel', {
          defaultMessage: 'Reload page'
        })))))
      }, {
        durationMs: 1000 * 60 * 5
      });
    } else {
      notifySuccess({
        title: notificationTitle
      });
    }
  }, [notificationTitle, notifySuccess, pageReloadText]);
  const onUserProfileUpdate = (0, _react.useCallback)(updatedData => {
    if (isMounted.current) {
      setIsLoading(false);
    }
    if (notificationSuccessEnabled) {
      const isRefreshRequired = pageReloadChecker === null || pageReloadChecker === void 0 ? void 0 : pageReloadChecker(userProfileSnapshot.current, updatedData);
      showSuccessNotification({
        isRefreshRequired
      });
    }
  }, [notificationSuccessEnabled, showSuccessNotification, pageReloadChecker]);
  const update = (0, _react.useCallback)(updatedData => {
    userProfileSnapshot.current = (0, _lodash.merge)({}, userProfileData);
    setIsLoading(true);
    return userProfileApiClient.partialUpdate(updatedData).then(() => {
      onUserProfileUpdate(updatedData);
      return updatedData;
    });
  }, [userProfileApiClient, onUserProfileUpdate, userProfileData]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  return {
    /** Update the user profile */
    update,
    /** Handler to show a notification after the user profile has been updated */
    showSuccessNotification,
    /** The current user profile data */
    userProfileData,
    /** Flag to indicate if currently updating */
    isLoading,
    /** Flag to indicate if user profile is enabled */
    userProfileEnabled,
    /** Flag to indicate if the user profile has been loaded */
    userProfileLoaded
  };
};
exports.useUpdateUserProfile = useUpdateUserProfile;