"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomalySummary = exports.durationAnomalyAlertFactory = void 0;
var _server = require("@kbn/alerting-plugin/server");
var _moment = _interopRequireDefault(require("moment"));
var _server2 = require("@kbn/core/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _uptime_duration_anomaly = require("@kbn/response-ops-rule-params/uptime_duration_anomaly");
var _common = require("@kbn/observability-plugin/common");
var _std = require("@kbn/std");
var _lib = require("../lib");
var _common2 = require("./common");
var _uptime_alerts = require("../../../../common/constants/uptime_alerts");
var _translations = require("./translations");
var _lib2 = require("../../../../common/lib");
var _translations2 = require("../../../../common/rules/legacy_uptime/translations");
var _get_monitor_url = require("../../../../common/utils/get_monitor_url");
var _action_variables = require("./action_variables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAnomalySummary = (anomaly, monitorInfo) => {
  var _monitorInfo$url;
  return {
    severity: (0, _mlAnomalyUtils.getSeverityType)(anomaly.severity),
    severityScore: Math.round(anomaly.severity),
    anomalyStartTimestamp: (0, _moment.default)(anomaly.source.timestamp).toISOString(),
    monitor: anomaly.source['monitor.id'],
    monitorUrl: (_monitorInfo$url = monitorInfo.url) === null || _monitorInfo$url === void 0 ? void 0 : _monitorInfo$url.full,
    slowestAnomalyResponse: Math.round(anomaly.actualSort / 1000) + ' ms',
    expectedResponseTime: Math.round(anomaly.typicalSort / 1000) + ' ms',
    observerLocation: anomaly.entityValue,
    bucketSpan: anomaly.source.bucket_span
  };
};
exports.getAnomalySummary = getAnomalySummary;
const getAnomalies = async (plugins, savedObjectsClient, params, lastCheckedAt) => {
  const fakeRequest = {};
  const {
    getAnomaliesTableData
  } = plugins.ml.resultsServiceProvider(fakeRequest, savedObjectsClient);
  return await getAnomaliesTableData([(0, _lib2.getMLJobId)(params.monitorId)], [], [], 'auto', params.severity,
  // Lookback window will be 2x Bucket time span, for uptime job, for now bucket
  // timespan will always be 15minute
  (0, _moment.default)(lastCheckedAt).subtract(30, 'minute').valueOf(), (0, _moment.default)().valueOf(), Intl.DateTimeFormat().resolvedOptions().timeZone, 500, 10, undefined);
};
const durationAnomalyAlertFactory = (server, libs, plugins) => ({
  id: _uptime_alerts.CLIENT_ALERT_TYPES.DURATION_ANOMALY,
  category: _server2.DEFAULT_APP_CATEGORIES.observability.id,
  producer: 'uptime',
  solution: _common.observabilityFeatureId,
  name: _translations.durationAnomalyTranslations.alertFactoryName,
  validate: {
    params: _uptime_duration_anomaly.uptimeDurationAnomalyRuleParamsSchema
  },
  defaultActionGroupId: _uptime_alerts.DURATION_ANOMALY.id,
  actionGroups: [{
    id: _uptime_alerts.DURATION_ANOMALY.id,
    name: _uptime_alerts.DURATION_ANOMALY.name
  }],
  actionVariables: {
    context: [_action_variables.ACTION_VARIABLES[_action_variables.ALERT_DETAILS_URL], _action_variables.ACTION_VARIABLES[_action_variables.ALERT_REASON_MSG], _action_variables.ACTION_VARIABLES[_action_variables.VIEW_IN_APP_URL], ..._translations.durationAnomalyTranslations.actionVariables, ..._translations.commonStateTranslations],
    state: [..._translations.durationAnomalyTranslations.actionVariables, ..._translations.commonStateTranslations]
  },
  isExportable: true,
  minimumLicenseRequired: 'platinum',
  doesSetRecoveryContext: true,
  async executor({
    params,
    services: {
      alertsClient,
      savedObjectsClient,
      scopedClusterClient
    },
    spaceId,
    state,
    startedAt
  }) {
    var _params$stackVersion, _await$getAnomalies;
    if (!alertsClient) {
      throw new _server.AlertsClientError();
    }
    const uptimeEsClient = new _lib.UptimeEsClient(savedObjectsClient, scopedClusterClient.asCurrentUser, {
      stackVersion: (_params$stackVersion = params.stackVersion) !== null && _params$stackVersion !== void 0 ? _params$stackVersion : '8.9.0'
    });
    const {
      share,
      basePath
    } = server;
    const alertsLocator = share.url.locators.get(_common.alertsLocatorID);
    const {
      anomalies
    } = (_await$getAnomalies = await getAnomalies(plugins, savedObjectsClient, params, state.lastCheckedAt)) !== null && _await$getAnomalies !== void 0 ? _await$getAnomalies : {};
    const foundAnomalies = (anomalies === null || anomalies === void 0 ? void 0 : anomalies.length) > 0;
    if (foundAnomalies) {
      const monitorInfo = await libs.requests.getLatestMonitor({
        uptimeEsClient,
        dateStart: 'now-15m',
        dateEnd: 'now',
        monitorId: params.monitorId
      });
      await (0, _std.asyncForEach)(anomalies, async (anomaly, index) => {
        const summary = getAnomalySummary(anomaly, monitorInfo);
        const alertReasonMessage = (0, _common2.generateAlertMessage)(_translations2.DurationAnomalyTranslations.defaultActionMessage, summary);
        const alertId = _uptime_alerts.DURATION_ANOMALY.id + index;
        const {
          start,
          uuid
        } = alertsClient === null || alertsClient === void 0 ? void 0 : alertsClient.report({
          id: alertId,
          actionGroup: _uptime_alerts.DURATION_ANOMALY.id,
          payload: {
            'monitor.id': params.monitorId,
            'url.full': summary.monitorUrl,
            'observer.geo.name': summary.observerLocation,
            'anomaly.start': summary.anomalyStartTimestamp,
            'anomaly.bucket_span.minutes': summary.bucketSpan,
            [_ruleDataUtils.ALERT_EVALUATION_VALUE]: anomaly.actualSort,
            [_ruleDataUtils.ALERT_EVALUATION_THRESHOLD]: anomaly.typicalSort,
            [_ruleDataUtils.ALERT_REASON]: alertReasonMessage
          },
          state: {
            ...(0, _common2.updateState)(state, false),
            ...summary
          }
        });
        const indexedStartedAt = start !== null && start !== void 0 ? start : startedAt.toISOString();
        const relativeViewInAppUrl = (0, _get_monitor_url.getMonitorRouteFromMonitorId)({
          monitorId: alertId,
          dateRangeEnd: 'now',
          dateRangeStart: indexedStartedAt
        });
        alertsClient.setAlertData({
          id: _uptime_alerts.DURATION_ANOMALY.id,
          context: {
            [_action_variables.ALERT_DETAILS_URL]: await (0, _common.getAlertUrl)(uuid, spaceId, indexedStartedAt, alertsLocator, basePath.publicBaseUrl),
            [_action_variables.ALERT_REASON_MSG]: alertReasonMessage,
            [_action_variables.VIEW_IN_APP_URL]: (0, _common2.getViewInAppUrl)(basePath, spaceId, relativeViewInAppUrl),
            ...summary
          }
        });
      });
    }
    await (0, _common2.setRecoveredAlertsContext)({
      alertsClient,
      alertsLocator,
      basePath,
      defaultStartedAt: startedAt.toISOString(),
      spaceId
    });
    return {
      state: (0, _common2.updateState)(state, foundAnomalies)
    };
  },
  alerts: _common2.UptimeRuleTypeAlertDefinition,
  getViewInAppRelativeUrl: ({
    rule
  }) => _common.observabilityPaths.ruleDetails(rule.id)
});
exports.durationAnomalyAlertFactory = durationAnomalyAlertFactory;