"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PageRouter = exports.MONITORING_OVERVIEW_LABEL = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../common/constants");
var _pages = require("./pages");
var _certificates = require("./pages/certificates");
var _overview = require("./pages/overview");
var _synthetics_checks = require("./pages/synthetics/synthetics_checks");
var _monitor_title = require("./components/monitor/monitor_title");
var _uptime_date_picker = require("./components/common/uptime_date_picker");
var _cert_refresh_btn = require("./components/certificates/cert_refresh_btn");
var _certificate_title = require("./components/certificates/certificate_title");
var _step_detail_page = require("./pages/synthetics/step_detail_page");
var _uptime_page_template = require("./app/uptime_page_template");
var _utils = require("./state/api/utils");
var _settings_bottom_bar = require("./components/settings/settings_bottom_bar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const baseTitle = _i18n.i18n.translate('xpack.uptime.routes.legacyBaseTitle', {
  defaultMessage: 'Uptime - Kibana'
});
const MONITORING_OVERVIEW_LABEL = exports.MONITORING_OVERVIEW_LABEL = _i18n.i18n.translate('xpack.uptime.overview.heading', {
  defaultMessage: 'Monitors'
});
const getRoutes = () => {
  return [{
    title: _i18n.i18n.translate('xpack.uptime.monitorRoute.title', {
      defaultMessage: 'Monitor | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.MONITOR_ROUTE,
    component: _pages.MonitorPage,
    dataTestSubj: 'uptimeMonitorPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_monitor_title.MonitorPageTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 20
        }
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_uptime_date_picker.UptimeDatePicker, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 26
        }
      })]
    }
  }, {
    title: _i18n.i18n.translate('xpack.uptime.settingsRoute.title', {
      defaultMessage: `Settings | {baseTitle}`,
      values: {
        baseTitle
      }
    }),
    path: _constants.SETTINGS_ROUTE,
    component: _pages.SettingsPage,
    dataTestSubj: 'uptimeSettingsPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.uptime.settings.heading",
        defaultMessage: "Uptime settings",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      })
    },
    bottomBar: /*#__PURE__*/_react.default.createElement(_settings_bottom_bar.SettingsBottomBar, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 18
      }
    }),
    bottomBarProps: {
      paddingSize: 'm'
    }
  }, {
    title: _i18n.i18n.translate('xpack.uptime.certificatesRoute.title', {
      defaultMessage: `Certificates | {baseTitle}`,
      values: {
        baseTitle
      }
    }),
    path: _constants.CERTIFICATES_ROUTE,
    component: _certificates.CertificatesPage,
    dataTestSubj: 'uptimeCertificatesPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_certificate_title.CertificateTitle, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 20
        }
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_cert_refresh_btn.CertRefreshBtn, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 26
        }
      })]
    }
  }, {
    title: _i18n.i18n.translate('xpack.uptime.stepDetailRoute.title', {
      defaultMessage: 'Synthetics detail | {baseTitle}',
      values: {
        baseTitle
      }
    }),
    path: _constants.STEP_DETAIL_ROUTE,
    component: _pages.StepDetailPage,
    dataTestSubj: 'uptimeStepDetailPage',
    pageHeader: {
      children: /*#__PURE__*/_react.default.createElement(_step_detail_page.StepDetailPageChildren, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 19
        }
      }),
      pageTitle: /*#__PURE__*/_react.default.createElement(_step_detail_page.StepDetailPageHeader, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 20
        }
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_step_detail_page.StepDetailPageRightSideItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 26
        }
      })]
    }
  }, {
    title: baseTitle,
    path: _constants.SYNTHETIC_CHECK_STEPS_ROUTE,
    component: _synthetics_checks.SyntheticsCheckSteps,
    dataTestSubj: 'uptimeSyntheticCheckStepsPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement(_synthetics_checks.SyntheticsCheckStepsPageHeader, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 20
        }
      }),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_synthetics_checks.SyntheticsCheckStepsPageRightSideItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 26
        }
      })]
    }
  }, {
    title: baseTitle,
    path: _constants.OVERVIEW_ROUTE,
    component: _overview.OverviewPageComponent,
    dataTestSubj: 'uptimeOverviewPage',
    pageHeader: {
      pageTitle: MONITORING_OVERVIEW_LABEL,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_uptime_date_picker.UptimeDatePicker, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 26
        }
      })]
    }
  }, {
    title: _i18n.i18n.translate('xpack.uptime.mappingErrorRoute.title', {
      defaultMessage: 'Synthetics | mapping error'
    }),
    path: _constants.MAPPING_ERROR_ROUTE,
    component: _pages.MappingErrorPage,
    dataTestSubj: 'uptimeMappingErrorPage',
    pageHeader: {
      pageTitle: /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.uptime.mappingErrorRoute.pageHeader.title",
        defaultMessage: "Mapping error",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 13
        }
      })),
      rightSideItems: []
    }
  }];
};
const RouteInit = ({
  path,
  title
}) => {
  (0, _react.useEffect)(() => {
    document.title = title;
  }, [path, title]);
  return null;
};
const PageRouter = () => {
  const routes = getRoutes();
  const {
    addInspectorRequest
  } = (0, _public2.useInspectorContext)();
  _utils.apiService.addInspectorRequest = addInspectorRequest;
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  }, routes.map(({
    title,
    path,
    component: RouteComponent,
    dataTestSubj,
    pageHeader,
    ...pageTemplateProps
  }) => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: path,
    key: dataTestSubj,
    exact: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(RouteInit, {
    title: title,
    path: path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_uptime_page_template.UptimePageTemplateComponent, (0, _extends2.default)({
    path: path,
    pageHeader: pageHeader
  }, pageTemplateProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(RouteComponent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _pages.NotFoundPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }));
};
exports.PageRouter = PageRouter;