"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChecksNavigation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactRouterDom = require("react-router-dom");
var _moment = _interopRequireDefault(require("moment"));
var _i18n = require("@kbn/i18n");
var _monitor_status_column = require("../../components/overview/monitor_list/columns/monitor_status_column");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/pages/synthetics/checks_navigation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ChecksNavigation = ({
  timestamp,
  details
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const isMobile = (0, _eui.useIsWithinMaxBreakpoint)('s');
  const shortTimestamp = (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(timestamp));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsChecksNavigationPreviousCheckButton",
    size: isMobile ? 'xs' : 'm',
    iconType: "arrowLeft",
    isDisabled: !(details !== null && details !== void 0 && details.previous),
    onClick: () => {
      var _details$previous;
      history.push(`/journey/${details === null || details === void 0 ? void 0 : (_details$previous = details.previous) === null || _details$previous === void 0 ? void 0 : _details$previous.checkGroup}/steps`);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.synthetics.stepList.previousCheck",
    defaultMessage: "Previous check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: isMobile ? 'xs' : 'm',
    className: "eui-textNoWrap",
    "aria-label": _i18n.i18n.translate('xpack.uptime.synthetics.stepList.currentCheckAriaLabel', {
      defaultMessage: 'Current check: {shortTimestamp}',
      values: {
        shortTimestamp
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, shortTimestamp)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsChecksNavigationNextCheckButton",
    size: isMobile ? 'xs' : 'm',
    iconType: "arrowRight",
    iconSide: "right",
    isDisabled: !(details !== null && details !== void 0 && details.next),
    onClick: () => {
      var _details$next;
      history.push(`/journey/${details === null || details === void 0 ? void 0 : (_details$next = details.next) === null || _details$next === void 0 ? void 0 : _details$next.checkGroup}/steps`);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.synthetics.stepList.nextCheck",
    defaultMessage: "Next check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }))));
};
exports.ChecksNavigation = ChecksNavigation;