"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidCertVal = exports.SettingsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _selectors = require("../state/selectors");
var _dynamic_settings = require("../state/actions/dynamic_settings");
var _use_breadcrumbs = require("../hooks/use_breadcrumbs");
var _indices_form = require("../components/settings/indices_form");
var _certificate_form = require("../components/settings/certificate_form");
var Translations = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../../common/translations");
var _alert_defaults_form = require("../components/settings/alert_defaults_form");
var _settings_bottom_bar = require("../components/settings/settings_bottom_bar");
var _use_settings_errors = require("../components/settings/use_settings_errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/pages/settings.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isValidCertVal = val => {
  if (val === undefined || isNaN(val)) {
    return Translations.settings.mustBeNumber;
  }
  if (val <= 0) {
    return _translations2.VALUE_MUST_BE_GREATER_THAN_ZERO;
  }
  if (val % 1) {
    return _translations2.VALUE_MUST_BE_AN_INTEGER;
  }
};
exports.isValidCertVal = isValidCertVal;
const SettingsPage = () => {
  var _useKibana$services, _useKibana$services$a;
  const dss = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: Translations.settings.breadcrumbText
  }]);
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _dynamic_settings.getDynamicSettings)());
  }, [dispatch]);
  const [formFields, setFormFields] = (0, _react.useState)(dss.settings ? {
    ...dss.settings
  } : null);
  if (!dss.loadError && formFields === null && dss.settings) {
    setFormFields(Object.assign({}, {
      ...dss.settings
    }));
  }
  const {
    errors: fieldErrors,
    isFormDirty
  } = (0, _use_settings_errors.useSettingsErrors)(formFields);
  const isFormValid = !(fieldErrors && Object.values(fieldErrors).find(v => !!v));
  const onChangeFormField = (0, _react.useCallback)(changedField => {
    if (formFields) {
      setFormFields({
        ...formFields,
        ...changedField
      });
    }
  }, [formFields]);
  const onApply = event => {
    event.preventDefault();
    if (formFields) {
      dispatch((0, _dynamic_settings.setDynamicSettings)(formFields));
    }
  };
  const resetForm = () => setFormFields(dss.settings ? {
    ...dss.settings
  } : null);
  const canEdit = !!((_useKibana$services = (0, _public.useKibana)().services) !== null && _useKibana$services !== void 0 && (_useKibana$services$a = _useKibana$services.application) !== null && _useKibana$services$a !== void 0 && _useKibana$services$a.capabilities.uptime.configureSettings) || false;
  const isFormDisabled = dss.loading || !canEdit;
  const cannotEditNotice = canEdit ? null : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: Translations.settings.editNoticeTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, Translations.settings.editNoticeText), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  }, cannotEditNotice)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: "settings-form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_indices_form.IndicesForm, {
    loading: dss.loading,
    onChange: onChangeFormField,
    formFields: formFields,
    fieldErrors: fieldErrors,
    isDisabled: isFormDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_alert_defaults_form.AlertDefaultsForm, {
    loading: dss.loading,
    formFields: formFields,
    onChange: onChangeFormField,
    fieldErrors: fieldErrors,
    isDisabled: isFormDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_certificate_form.CertificateExpirationForm, {
    loading: dss.loading,
    onChange: onChangeFormField,
    formFields: formFields,
    fieldErrors: fieldErrors,
    isDisabled: isFormDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_settings_bottom_bar.SettingsActionBarPortal, {
    onApply: onApply,
    isFormDirty: isFormDirty,
    isFormDisabled: isFormDisabled,
    isFormValid: isFormValid,
    onCancel: resetForm,
    errors: fieldErrors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }));
};
exports.SettingsPage = SettingsPage;