"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertificatesPage = void 0;
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_breadcrumbs = require("../hooks/use_breadcrumbs");
var _dynamic_settings = require("../state/actions/dynamic_settings");
var _certificates = require("../components/certificates");
var _use_cert_search = require("../components/certificates/use_cert_search");
var _certificates2 = require("../state/certificates/certificates");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/pages/certificates.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = 10;
const LOCAL_STORAGE_KEY = 'xpack.uptime.certList.pageSize';
const getPageSizeValue = () => {
  var _localStorage$getItem;
  const value = parseInt((_localStorage$getItem = localStorage.getItem(LOCAL_STORAGE_KEY)) !== null && _localStorage$getItem !== void 0 ? _localStorage$getItem : '', 10);
  if (isNaN(value)) {
    return DEFAULT_PAGE_SIZE;
  }
  return value;
};
const CertificatesPage = () => {
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'certificates'
  });
  (0, _public.useTrackPageview)({
    app: 'uptime',
    path: 'certificates',
    delay: 15000
  });
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: 'Certificates'
  }]);
  const [page, setPage] = (0, _react.useState)({
    index: 0,
    size: getPageSizeValue()
  });
  const [sort, setSort] = (0, _react.useState)({
    field: 'not_after',
    direction: 'asc'
  });
  const [search, setSearch] = (0, _react.useState)('');
  const dispatch = (0, _reactRedux.useDispatch)();
  (0, _react.useEffect)(() => {
    dispatch((0, _dynamic_settings.getDynamicSettings)());
  }, [dispatch]);
  const certificates = (0, _use_cert_search.useCertSearch)({
    search,
    size: page.size,
    pageIndex: page.index,
    sortBy: sort.field,
    direction: sort.direction
  });
  (0, _react.useEffect)(() => {
    dispatch((0, _certificates2.setCertificatesTotalAction)({
      total: certificates.total
    }));
  }, [certificates.total, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_certificates.CertificateSearch, {
    setSearch: setSearch,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_certificates.CertificateList, {
    page: page,
    onChange: (pageVal, sortVal) => {
      setPage(pageVal);
      setSort(sortVal);
      localStorage.setItem(LOCAL_STORAGE_KEY, pageVal.size.toString());
    },
    sort: sort,
    certificates: certificates,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
};
exports.CertificatesPage = CertificatesPage;