"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertificateExpirationForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/settings/certificate_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CertificateExpirationForm = ({
  loading,
  onChange,
  formFields,
  fieldErrors,
  isDisabled
}) => {
  var _formFields$certExpir, _formFields$certAgeTh;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.certificationSectionTitle",
    defaultMessage: "Certificate Expiration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.expirationThreshold",
      defaultMessage: "Expiration/Age Thresholds",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.certificateThresholdDescription",
      defaultMessage: "Change the threshold for displaying and alerting on certificate errors. Note: this will affect any configured alerts.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    describedByIds: ['errorState'],
    error: fieldErrors === null || fieldErrors === void 0 ? void 0 : fieldErrors.expirationThresholdError,
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.expirationThresholdDefaultValue",
      defaultMessage: "The default value is {defaultValue}",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 29
          }
        }, _constants.DYNAMIC_SETTINGS_DEFAULTS.certExpirationThreshold)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }),
    isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.expirationThresholdError),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.errorStateLabel",
      defaultMessage: "Expiration threshold",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _translations.certificateFormTranslations.expirationInputAriaLabel,
    "data-test-subj": `expiration-threshold-input-${loading ? 'loading' : 'loaded'}`,
    fullWidth: true,
    disabled: isDisabled,
    isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.expirationThresholdError),
    isLoading: loading,
    value: (_formFields$certExpir = formFields === null || formFields === void 0 ? void 0 : formFields.certExpirationThreshold) !== null && _formFields$certExpir !== void 0 ? _formFields$certExpir : '',
    onChange: e => onChange({
      certExpirationThreshold: Number(e.target.value) || undefined
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.ageLimit.units.days",
    defaultMessage: "Days",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    describedByIds: ['warningState'],
    error: fieldErrors === null || fieldErrors === void 0 ? void 0 : fieldErrors.ageThresholdError,
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.ageThresholdDefaultValue",
      defaultMessage: "The default value is {defaultValue}",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 29
          }
        }, _constants.DYNAMIC_SETTINGS_DEFAULTS.certAgeThreshold)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 11
      }
    }),
    isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.ageThresholdError),
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.warningStateLabel",
      defaultMessage: "Age limit",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "aria-label": _translations.certificateFormTranslations.ageInputAriaLabel,
    "data-test-subj": `age-threshold-input-${loading ? 'loading' : 'loaded'}`,
    fullWidth: true,
    disabled: isDisabled,
    isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.ageThresholdError),
    isLoading: loading,
    value: (_formFields$certAgeTh = formFields === null || formFields === void 0 ? void 0 : formFields.certAgeThreshold) !== null && _formFields$certAgeTh !== void 0 ? _formFields$certAgeTh : '',
    onChange: ({
      target: {
        value
      }
    }) => onChange({
      certAgeThreshold: Number(value) || undefined
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.ageLimit.units.days",
    defaultMessage: "Days",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  })))))));
};
exports.CertificateExpirationForm = CertificateExpirationForm;