"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WHERE_ARE_MY_MONITORS = exports.TroubleshootPopover = exports.SYSTEM_CLOCK_OUT_OF_SYNC = exports.APPLY_ABSOLUTE_DATE_RANGE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _selectors = require("../../../state/selectors");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/troubleshoot_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TroubleshootPopover = () => {
  var _pingHistogram$histog;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(prevState => !prevState);
  const closePopover = () => setIsPopoverOpen(false);
  const {
    pingHistogram
  } = (0, _reactRedux.useSelector)(_selectors.selectPingHistogram);
  const updatedUrlParams = (0, _hooks.useUrlParams)()[1];
  const histogram = (_pingHistogram$histog = pingHistogram === null || pingHistogram === void 0 ? void 0 : pingHistogram.histogram) !== null && _pingHistogram$histog !== void 0 ? _pingHistogram$histog : [];
  const middleBucketTimestamp = histogram === null || histogram === void 0 ? void 0 : histogram[Math.floor(histogram.length / 2)].x;
  const firstBucketTimestamp = histogram === null || histogram === void 0 ? void 0 : histogram[0].x;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "syntheticsTroubleshootPopoverButton",
      onClick: onButtonClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 9
      }
    }, WHERE_ARE_MY_MONITORS),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "upCenter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, SYSTEM_CLOCK_OUT_OF_SYNC), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.monitorList.noMessage.troubleshoot",
    defaultMessage: "Try using an absolute date range. If monitors appears afterwards, there may be an issue with the system clock where Heartbeat or Kibana is installed.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "syntheticsTroubleshootPopoverButton",
    fullWidth: true,
    iconType: "calendar",
    size: "s",
    onClick: () => {
      if (middleBucketTimestamp && firstBucketTimestamp) {
        updatedUrlParams({
          dateRangeStart: new Date(firstBucketTimestamp).toISOString(),
          dateRangeEnd: new Date(middleBucketTimestamp).toISOString()
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, APPLY_ABSOLUTE_DATE_RANGE)));
};
exports.TroubleshootPopover = TroubleshootPopover;
const APPLY_ABSOLUTE_DATE_RANGE = exports.APPLY_ABSOLUTE_DATE_RANGE = _i18n.i18n.translate('xpack.uptime.monitorList.troubleshoot.tryDateRange', {
  defaultMessage: 'Apply absolute date range'
});
const WHERE_ARE_MY_MONITORS = exports.WHERE_ARE_MY_MONITORS = _i18n.i18n.translate('xpack.uptime.monitorList.troubleshoot.whereAreMyMonitors', {
  defaultMessage: 'Where are my monitors?'
});
const SYSTEM_CLOCK_OUT_OF_SYNC = exports.SYSTEM_CLOCK_OUT_OF_SYNC = _i18n.i18n.translate('xpack.uptime.monitorList.troubleshoot.systemClockOutOfSync', {
  defaultMessage: 'System clock may be out of sync'
});