"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListPageSizeSelectComponent = exports.MonitorListPageSizeSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/monitor_list_page_size_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PopoverButton = ({
  setIsOpen,
  size
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  color: "text",
  "data-test-subj": "xpack.uptime.monitorList.pageSizeSelect.popoverOpen",
  iconType: "arrowDown",
  iconSide: "right",
  onClick: () => setIsOpen(true),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.uptime.monitorList.pageSizePopoverButtonText",
  defaultMessage: "Rows per page: {size}",
  values: {
    size
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 27,
    columnNumber: 5
  }
}));
const items = [{
  'data-test-subj': 'xpack.uptime.monitorList.pageSizeSelect.sizeSelectItem10',
  key: '10 rows',
  numRows: 10
}, {
  'data-test-subj': 'xpack.uptime.monitorList.pageSizeSelect.sizeSelectItem25',
  key: '25 rows',
  numRows: 25
}, {
  'data-test-subj': 'xpack.uptime.monitorList.pageSizeSelect.sizeSelectItem50',
  key: '50 rows',
  numRows: 50
}, {
  'data-test-subj': 'xpack.uptime.monitorList.pageSizeSelect.sizeSelectItem100',
  key: '100 rows',
  numRows: 100
}];
const LOCAL_STORAGE_KEY = 'xpack.uptime.monitorList.pageSize';
/**
 * This component wraps the underlying UI functionality to make the component more testable.
 * The features leveraged in this function are tested elsewhere, and are not novel to this component.
 */
const MonitorListPageSizeSelect = ({
  size,
  setSize
}) => {
  const [, setUrlParams] = (0, _hooks.useUrlParams)();
  (0, _react.useEffect)(() => {
    localStorage.setItem(LOCAL_STORAGE_KEY, size.toString());
  }, [size]);
  return /*#__PURE__*/_react.default.createElement(MonitorListPageSizeSelectComponent, {
    size: size,
    setSize: setSize,
    setUrlParams: setUrlParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  });
};
exports.MonitorListPageSizeSelect = MonitorListPageSizeSelect;
/**
 * This function contains the UI functionality for the page select feature. It's agnostic to any
 * external services/features, and focuses only on providing the UI and handling user interaction.
 */
const MonitorListPageSizeSelectComponent = ({
  size,
  setSize,
  setUrlParams
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(PopoverButton, {
      setIsOpen: value => setIsOpen(value),
      size: size,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 15
      }
    }),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    anchorPosition: "upLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items.map(({
      'data-test-subj': dataTestSubj,
      key,
      numRows
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": dataTestSubj,
      key: key,
      icon: size === numRows ? 'check' : 'empty',
      onClick: () => {
        setSize(numRows);
        // reset pagination because the page size has changed
        setUrlParams({
          pagination: undefined
        });
        setIsOpen(false);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.monitorList.pageSizeSelect.numRowsItemMessage",
      defaultMessage: "{numRows} rows",
      values: {
        numRows
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }));
};
exports.MonitorListPageSizeSelectComponent = MonitorListPageSizeSelectComponent;