"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorListDrawer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _selectors = require("../../../../state/selectors");
var _monitor = require("../../../../state/actions/monitor");
var _monitor_list_drawer = require("./monitor_list_drawer");
var _hooks = require("../../../../hooks");
var _alerts = require("../../../../state/alerts/alerts");
var _contexts = require("../../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/monitor_list_drawer/list_drawer_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorListDrawer = ({
  summary
}) => {
  var _alerts$data;
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const monitorId = summary === null || summary === void 0 ? void 0 : summary.monitor_id;
  const {
    dateRangeStart: dateStart,
    dateRangeEnd: dateEnd
  } = (0, _hooks.useGetUrlParams)();
  const monitorDetails = (0, _reactRedux.useSelector)(state => (0, _selectors.monitorDetailsSelector)(state, summary));
  const isLoading = (0, _reactRedux.useSelector)(_selectors.monitorDetailsLoadingSelector);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data: alerts,
    loading: alertsLoading
  } = (0, _reactRedux.useSelector)(_alerts.alertsSelector);
  const hasAlert = ((_alerts$data = alerts === null || alerts === void 0 ? void 0 : alerts.data) !== null && _alerts$data !== void 0 ? _alerts$data : []).find(alert => alert.params.search.includes(monitorId));
  (0, _react.useEffect)(() => {
    dispatch(_monitor.getMonitorDetailsAction.get({
      dateStart,
      dateEnd,
      monitorId
    }));
  }, [dateStart, dateEnd, monitorId, dispatch, hasAlert, lastRefresh]);
  return /*#__PURE__*/_react.default.createElement(_monitor_list_drawer.MonitorListDrawerComponent, {
    monitorDetails: monitorDetails,
    summary: summary,
    loading: isLoading || alertsLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
};
exports.MonitorListDrawer = MonitorListDrawer;