"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsPopoverComponent = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _integration_group = require("./integration_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/monitor_list_drawer/actions_popover/actions_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ActionsPopoverComponent = ({
  summary,
  popoverState,
  togglePopoverIsVisible
}) => {
  var _summary$state, _summary$state$url;
  const popoverId = `${summary.monitor_id}_popover`;
  const monitorUrl = summary === null || summary === void 0 ? void 0 : (_summary$state = summary.state) === null || _summary$state === void 0 ? void 0 : (_summary$state$url = _summary$state.url) === null || _summary$state$url === void 0 ? void 0 : _summary$state$url.full;
  const isPopoverOpen = !!popoverState && popoverState.open && popoverState.id === popoverId;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "aria-label": _i18n.i18n.translate('xpack.uptime.monitorList.observabilityIntegrationsColumn.popoverIconButton.ariaLabel', {
        defaultMessage: 'Opens integrations popover for monitor with url {monitorUrl}',
        description: 'A message explaining that this button opens a popover with links to other apps for a given monitor',
        values: {
          monitorUrl
        }
      }),
      "data-test-subj": `xpack.uptime.monitorList.actionsPopover.${summary.monitor_id}`,
      onClick: () => togglePopoverIsVisible({
        id: popoverId,
        open: true
      }),
      iconType: "arrowDown",
      iconSide: "right",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.uptime.monitorList.observabilityInvestigateColumn.popoverIconButton.label', {
      defaultMessage: 'Investigate'
    })),
    closePopover: () => togglePopoverIsVisible({
      id: popoverId,
      open: false
    }),
    id: popoverId,
    isOpen: isPopoverOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_group.IntegrationGroup, {
    summary: summary,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }));
};
exports.ActionsPopoverComponent = ActionsPopoverComponent;