"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorList = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _ebtTools = require("@kbn/ebt-tools");
var _actions = require("../../../state/actions");
var _selectors = require("../../../state/selectors");
var _monitor_list = require("./monitor_list");
var _hooks = require("../../../hooks");
var _contexts = require("../../../contexts");
var _alerts = require("../../../state/alerts/alerts");
var _use_mapping_check = require("../../../hooks/use_mapping_check");
var _use_overview_filter_check = require("../../../hooks/use_overview_filter_check");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/monitor_list_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_PAGE_SIZE = 10;
const LOCAL_STORAGE_KEY = 'xpack.uptime.monitorList.pageSize';
const getPageSizeValue = () => {
  var _localStorage$getItem;
  const value = parseInt((_localStorage$getItem = localStorage.getItem(LOCAL_STORAGE_KEY)) !== null && _localStorage$getItem !== void 0 ? _localStorage$getItem : '', 10);
  if (isNaN(value)) {
    return DEFAULT_PAGE_SIZE;
  }
  return value;
};
const MonitorList = props => {
  const filters = (0, _reactRedux.useSelector)(_selectors.esKuerySelector);
  const {
    filterCheck,
    pending
  } = (0, _use_overview_filter_check.useOverviewFilterCheck)();
  const [pageSize, setPageSize] = (0, _react.useState)(getPageSizeValue);
  const dispatch = (0, _reactRedux.useDispatch)();
  const [getUrlValues] = (0, _hooks.useUrlParams)();
  const {
    dateRangeStart,
    dateRangeEnd,
    pagination,
    statusFilter,
    query
  } = getUrlValues();
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const monitorList = (0, _reactRedux.useSelector)(_selectors.monitorListSelector);
  (0, _use_mapping_check.useMappingCheck)(monitorList.error);
  (0, _ebtTools.usePageReady)({
    isReady: Boolean(monitorList.isLoaded),
    isRefreshing: false
  });
  (0, _react.useEffect)(() => {
    filterCheck(() => dispatch((0, _actions.getMonitorList)({
      dateRangeStart,
      dateRangeEnd,
      filters,
      pageSize,
      pagination,
      statusFilter,
      query
    })));
  }, [dispatch, dateRangeStart, dateRangeEnd, filters, filterCheck, lastRefresh, pageSize, pagination, statusFilter, query]);
  (0, _react.useEffect)(() => {
    dispatch(_alerts.getMonitorAlertsAction.get());
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    dispatch(_alerts.getConnectorsAction.get());
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_monitor_list.MonitorListComponent, (0, _extends2.default)({}, props, {
    monitorList: monitorList,
    pageSize: pageSize,
    setPageSize: setPageSize,
    isPending: pending,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }));
};
exports.MonitorList = MonitorList;