"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertStatusColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _hooks = require("../../../../hooks");
var _translations = require("../../../certificates/translations");
var _constants = require("../../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/columns/cert_status_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Span = _styledComponents.default.span`
  margin-left: 5px;
  vertical-align: middle;
`;
const H4Text = _styledComponents.default.h4`
  &&& {
    margin: 0 0 0 4px;
    display: inline-block;
    color: inherit;
  }
`;
const CertStatusColumn = ({
  expiry,
  boldStyle = false
}) => {
  const notAfter = expiry === null || expiry === void 0 ? void 0 : expiry.not_after;
  const certStatus = (0, _hooks.useCertStatus)(notAfter);
  const relativeDate = (0, _moment.default)(notAfter).fromNow();
  const CertStatus = ({
    color,
    text
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: (0, _moment.default)(notAfter).format('L LT'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      tabIndex: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: color,
      type: "lock",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 11
      }
    }), boldStyle ? /*#__PURE__*/_react.default.createElement(H4Text, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 13
      }
    }, text, " ", relativeDate) : /*#__PURE__*/_react.default.createElement(Span, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 13
      }
    }, text, " ", relativeDate)));
  };
  if (certStatus === _constants.CERT_STATUS.EXPIRING_SOON) {
    return /*#__PURE__*/_react.default.createElement(CertStatus, {
      color: "warning",
      text: _translations.EXPIRES_SOON,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 12
      }
    });
  }
  if (certStatus === _constants.CERT_STATUS.EXPIRED) {
    return /*#__PURE__*/_react.default.createElement(CertStatus, {
      color: "danger",
      text: _translations.EXPIRED,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 12
      }
    });
  }
  return certStatus ? /*#__PURE__*/_react.default.createElement(CertStatus, {
    color: "success",
    text: _translations.EXPIRES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 23
    }
  }) : /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 71
    }
  }, "--");
};
exports.CertStatusColumn = CertStatusColumn;