"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TAG_KEY_FOR_AND_CONDITION = exports.FilterGroup = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _public = require("@kbn/observability-shared-plugin/public");
var _use_filter_update = require("../../../hooks/use_filter_update");
var _use_selected_filters = require("../../../hooks/use_selected_filters");
var _selected_filters = require("./selected_filters");
var _uptime_data_view_context = require("../../../contexts/uptime_data_view_context");
var _hooks = require("../../../hooks");
var _client_defaults = require("../../../../../common/constants/client_defaults");
var _uptime_refresh_context = require("../../../contexts/uptime_refresh_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/filter_group/filter_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Container = (0, _styledComponents.default)(_eui.EuiFilterGroup)`
  margin-bottom: 10px;
`;
const TAG_KEY_FOR_AND_CONDITION = exports.TAG_KEY_FOR_AND_CONDITION = 'useANDForTagsFilter';
const FilterGroup = () => {
  const [updatedFieldValues, setUpdatedFieldValues] = (0, _react.useState)({
    fieldName: '',
    values: [],
    notValues: []
  });
  (0, _use_filter_update.useFilterUpdate)(updatedFieldValues.fieldName, updatedFieldValues.values, updatedFieldValues.notValues);
  const {
    refreshApp
  } = (0, _uptime_refresh_context.useUptimeRefreshContext)();
  const {
    dateRangeStart,
    dateRangeEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    inspectorAdapters
  } = (0, _public.useInspectorContext)();
  const {
    filtersList
  } = (0, _use_selected_filters.useSelectedFilters)();
  const dataView = (0, _uptime_data_view_context.useUptimeDataView)();
  const [useLogicalAND, setLogicalANDForTag] = (0, _useLocalStorage.default)(TAG_KEY_FOR_AND_CONDITION, false);
  const onFilterFieldChange = (0, _react.useCallback)((fieldName, values, notValues) => {
    setUpdatedFieldValues({
      fieldName,
      values,
      notValues
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Container, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, dataView && filtersList.map(({
    field,
    label,
    selectedItems,
    excludedItems
  }) => /*#__PURE__*/_react.default.createElement(_public.FieldValueSuggestions, {
    key: field,
    compressed: false,
    dataViewTitle: dataView.title,
    sourceField: field,
    label: label,
    selectedValue: selectedItems,
    excludedValue: excludedItems,
    onChange: (values, notValues, isLogicalAND) => {
      onFilterFieldChange(field, values !== null && values !== void 0 ? values : [], notValues !== null && notValues !== void 0 ? notValues : []);
      if (isLogicalAND !== undefined) {
        setLogicalANDForTag(isLogicalAND);
        setTimeout(() => refreshApp(), 0);
      }
    },
    asCombobox: false,
    asFilterButton: true,
    forceOpen: false,
    filters: [{
      exists: {
        field: 'summary'
      }
    }, _client_defaults.EXCLUDE_RUN_ONCE_FILTER],
    cardinalityField: "monitor.id",
    time: {
      from: dateRangeStart,
      to: dateRangeEnd
    },
    inspector: {
      adapter: inspectorAdapters.requests,
      title: 'get' + (0, _lodash.capitalize)(label) + 'FilterValues'
    },
    showLogicalConditionSwitch: field === 'tags',
    useLogicalAND: field === 'tags' ? useLogicalAND : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_selected_filters.SelectedFilters, {
    onChange: onFilterFieldChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }));
};
exports.FilterGroup = FilterGroup;