"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectSeverity = exports.SEVERITY_OPTIONS = exports.DEFAULT_SEVERITY = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_severity_color = require("@kbn/ml-anomaly-utils/get_severity_color");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/anomaly_alert/select_severity.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const warningLabel = _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.warningLabel', {
  defaultMessage: 'warning'
});
const minorLabel = _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.minorLabel', {
  defaultMessage: 'minor'
});
const majorLabel = _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.majorLabel', {
  defaultMessage: 'major'
});
const criticalLabel = _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.criticalLabel', {
  defaultMessage: 'critical'
});
const optionsMap = {
  [warningLabel]: 0,
  [minorLabel]: 25,
  [majorLabel]: 50,
  [criticalLabel]: 75
};
const SEVERITY_OPTIONS = exports.SEVERITY_OPTIONS = [{
  val: 0,
  display: warningLabel,
  color: (0, _get_severity_color.getSeverityColor)(0)
}, {
  val: 25,
  display: minorLabel,
  color: (0, _get_severity_color.getSeverityColor)(25)
}, {
  val: 50,
  display: majorLabel,
  color: (0, _get_severity_color.getSeverityColor)(50)
}, {
  val: 75,
  display: criticalLabel,
  color: (0, _get_severity_color.getSeverityColor)(75)
}];
function optionValueToThreshold(value) {
  // Get corresponding threshold object with required display and val properties from the specified value.
  let threshold = SEVERITY_OPTIONS.find(opt => opt.val === value);

  // Default to warning if supplied value doesn't map to one of the options.
  if (threshold === undefined) {
    threshold = SEVERITY_OPTIONS[0];
  }
  return threshold;
}
const DEFAULT_SEVERITY = exports.DEFAULT_SEVERITY = SEVERITY_OPTIONS[3];
const getSeverityOptions = () => SEVERITY_OPTIONS.map(({
  color,
  display,
  val
}) => ({
  'data-test-subj': `alertAnomaly${display}`,
  value: display,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    style: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, display)),
  dropdownDisplay: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    style: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 9
    }
  }, display), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.controls.selectSeverity.scoreDetailsDescription",
    defaultMessage: "score {value} and above",
    values: {
      value: val
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }))))
}));
const SelectSeverity = ({
  onChange,
  value
}) => {
  const [severity, setSeverity] = (0, _react.useState)(DEFAULT_SEVERITY);
  const onSeverityChange = valueDisplay => {
    const option = optionValueToThreshold(optionsMap[valueDisplay]);
    setSeverity(option);
    onChange(option);
  };
  (0, _react.useEffect)(() => {
    setSeverity(value);
  }, [value]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    hasDividers: true,
    style: {
      width: 200
    },
    options: getSeverityOptions(),
    valueOfSelected: severity.display,
    onChange: onSeverityChange,
    "data-test-subj": 'anomalySeveritySelect',
    "aria-label": _i18n.i18n.translate('xpack.uptime.controls.selectSeverity.ariaLabel', {
      defaultMessage: 'Anomaly severity'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  });
};
exports.SelectSeverity = SelectSeverity;