"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertExpressionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/alert_expression_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getColor = (isOpen, isEnabled, isInvalid) => {
  if (isInvalid === true) return 'danger';
  if (isEnabled === false) return 'subdued';
  return isOpen ? 'primary' : 'success';
};
const AlertExpressionPopover = ({
  'aria-label': ariaLabel,
  content,
  'data-test-subj': dataTestSubj,
  description,
  isEnabled,
  isInvalid,
  id,
  value
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: id,
    anchorPosition: "downLeft",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
      "aria-label": ariaLabel,
      color: getColor(isOpen, isEnabled, isInvalid),
      "data-test-subj": dataTestSubj,
      description: description,
      isActive: isOpen,
      onClick: isEnabled ? () => setIsOpen(!isOpen) : undefined,
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }),
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, content);
};
exports.AlertExpressionPopover = AlertExpressionPopover;