"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _useWindowSize = _interopRequireDefault(require("react-use/lib/useWindowSize"));
var _waterfall_chart = require("../context/waterfall_chart");
var _styles = require("./styles");
var _constants = require("./constants");
var _sidebar = require("./sidebar");
var _legend = require("./legend");
var _use_bar_charts = require("./use_bar_charts");
var _waterfall_bar_chart = require("./waterfall_bar_chart");
var _waterfall_chart_fixed_axis = require("./waterfall_chart_fixed_axis");
var _network_requests_total = require("./network_requests_total");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/synthetics/waterfall/components/waterfall_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const WaterfallChart = ({
  tickFormat,
  domain,
  barStyleAccessor,
  renderSidebarItem,
  renderLegendItem,
  renderFilter,
  renderFlyout,
  maxHeight = '800px',
  fullHeight = false
}) => {
  const {
    data,
    showOnlyHighlightedNetworkRequests,
    sidebarItems,
    legendItems,
    totalNetworkRequests,
    highlightedNetworkRequests,
    fetchedNetworkRequests
  } = (0, _waterfall_chart.useWaterfallContext)();
  const {
    width
  } = (0, _useWindowSize.default)();
  const chartWrapperDivRef = (0, _react.useRef)(null);
  const legendDivRef = (0, _react.useRef)(null);
  const [height, setHeight] = (0, _react.useState)(maxHeight);
  const shouldRenderSidebar = !!(sidebarItems && renderSidebarItem);
  const shouldRenderLegend = !!(legendItems && legendItems.length > 0 && renderLegendItem);
  (0, _react.useEffect)(() => {
    if (fullHeight && chartWrapperDivRef.current && legendDivRef.current) {
      const chartOffset = chartWrapperDivRef.current.getBoundingClientRect().top;
      const legendOffset = legendDivRef.current.getBoundingClientRect().height;
      setHeight(`calc(100vh - ${chartOffset + _constants.CHART_LEGEND_PADDING + legendOffset}px)`);
    }
  }, [chartWrapperDivRef, fullHeight, legendDivRef, width]);
  const chartsToDisplay = (0, _use_bar_charts.useBarCharts)({
    data
  });
  return /*#__PURE__*/_react.default.createElement(_styles.RelativeContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartFixedTopContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartTopContainer, {
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, shouldRenderSidebar && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartSidebarWrapper, {
    grow: _constants.SIDEBAR_GROW_SIZE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartFixedTopContainerSidebarCover, {
    paddingSize: "none",
    hasShadow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_network_requests_total.NetworkRequestsTotal, {
    totalNetworkRequests: totalNetworkRequests,
    highlightedNetworkRequests: highlightedNetworkRequests,
    fetchedNetworkRequests: fetchedNetworkRequests,
    showHighlightedNetworkRequests: showOnlyHighlightedNetworkRequests,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 15
    }
  }), renderFilter && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartFilterContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 17
    }
  }, renderFilter())), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartAxisOnlyContainer, {
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    "data-test-subj": "axisOnlyWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_chart_fixed_axis.WaterfallChartFixedAxis, {
    domain: domain,
    barStyleAccessor: barStyleAccessor,
    tickFormat: tickFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartOuterContainer, {
    height: height,
    "data-test-subj": "waterfallOuterContainer",
    ref: chartWrapperDivRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, shouldRenderSidebar && /*#__PURE__*/_react.default.createElement(_sidebar.Sidebar, {
    items: sidebarItems,
    render: renderSidebarItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 35
    }
  }), /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartAxisOnlyContainer, {
    grow: shouldRenderSidebar ? _constants.MAIN_GROW_SIZE : true,
    "data-test-subj": "dataOnlyWrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, chartsToDisplay.map((chartData, ind) => /*#__PURE__*/_react.default.createElement(_waterfall_bar_chart.WaterfallBarChart, {
    index: ind,
    key: ind,
    chartData: chartData,
    domain: domain,
    barStyleAccessor: barStyleAccessor,
    tickFormat: tickFormat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }))))), shouldRenderLegend && /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartLegendContainer, {
    ref: legendDivRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_legend.Legend, {
    items: legendItems,
    render: renderLegendItem,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  })), renderFlyout && renderFlyout());
};
exports.WaterfallChart = WaterfallChart;