"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkRequestsTotal = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/synthetics/waterfall/components/network_requests_total.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NetworkRequestsTotal = ({
  totalNetworkRequests,
  fetchedNetworkRequests,
  highlightedNetworkRequests,
  showHighlightedNetworkRequests
}) => {
  return /*#__PURE__*/_react.default.createElement(_styles.NetworkRequestsTotalStyle, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.synthetics.waterfall.requestsTotalMessage",
    defaultMessage: "{numNetworkRequests} network requests",
    values: {
      numNetworkRequests: totalNetworkRequests > fetchedNetworkRequests ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.uptime.synthetics.waterfall.requestsTotalMessage.first",
        defaultMessage: "First {count}",
        values: {
          count: `${fetchedNetworkRequests}/${totalNetworkRequests}`
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 36,
          columnNumber: 17
        }
      }) : totalNetworkRequests
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 9
    }
  }), ' ', showHighlightedNetworkRequests && highlightedNetworkRequests >= 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.synthetics.waterfall.requestsHighlightedMessage",
    defaultMessage: "({numHighlightedRequests} match the filter)",
    values: {
      numHighlightedRequests: highlightedNetworkRequests
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  })), totalNetworkRequests > fetchedNetworkRequests && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: 'info',
    content: _i18n.i18n.translate('xpack.uptime.synthetics.waterfall.requestsTotalMessage.info', {
      defaultMessage: 'Waterfall view only shows up to 1000 requests'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }));
};
exports.NetworkRequestsTotal = NetworkRequestsTotal;