"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderLegendItem = exports.WaterfallChartWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _data_formatting = require("./data_formatting");
var _waterfall = require("../../waterfall");
var _waterfall_filter = require("./waterfall_filter");
var _waterfall_flyout = require("./waterfall_flyout");
var _waterfall_sidebar_item = require("./waterfall_sidebar_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/synthetics/step_detail/waterfall/waterfall_chart_wrapper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderLegendItem = item => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: item.colour,
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, item.name);
};
exports.renderLegendItem = renderLegendItem;
const WaterfallChartWrapper = ({
  data,
  total,
  markerItems,
  activeStep
}) => {
  const [query, setQuery] = (0, _react.useState)('');
  const [activeFilters, setActiveFilters] = (0, _react.useState)([]);
  const [onlyHighlighted, setOnlyHighlighted] = (0, _react.useState)(false);
  const [networkData] = (0, _react.useState)(data);
  const hasFilters = activeFilters.length > 0;
  const {
    series,
    domain,
    metadata,
    totalHighlightedRequests
  } = (0, _react.useMemo)(() => {
    return (0, _data_formatting.getSeriesAndDomain)(networkData, onlyHighlighted, query, activeFilters);
  }, [networkData, query, activeFilters, onlyHighlighted]);
  const sidebarItems = (0, _react.useMemo)(() => {
    return (0, _data_formatting.getSidebarItems)(networkData, onlyHighlighted, query, activeFilters);
  }, [networkData, query, activeFilters, onlyHighlighted]);
  const legendItems = (0, _react.useMemo)(() => {
    return (0, _data_formatting.getLegendItems)();
  }, []);
  const {
    flyoutData,
    onBarClick,
    onProjectionClick,
    onSidebarClick,
    isFlyoutVisible,
    onFlyoutClose
  } = (0, _waterfall.useFlyout)(metadata);
  const renderFilter = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_waterfall_filter.WaterfallFilter, {
      query: query,
      setQuery: setQuery,
      activeFilters: activeFilters,
      setActiveFilters: setActiveFilters,
      onlyHighlighted: onlyHighlighted,
      setOnlyHighlighted: setOnlyHighlighted,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    });
  }, [activeFilters, setActiveFilters, onlyHighlighted, setOnlyHighlighted, query, setQuery]);
  const renderFlyout = (0, _react.useCallback)(() => {
    return /*#__PURE__*/_react.default.createElement(_waterfall_flyout.WaterfallFlyout, {
      flyoutData: flyoutData,
      onFlyoutClose: onFlyoutClose,
      isFlyoutVisible: isFlyoutVisible,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    });
  }, [flyoutData, isFlyoutVisible, onFlyoutClose]);
  const highestSideBarIndex = Math.max(...series.map(sr => sr.x));
  const renderSidebarItem = (0, _react.useCallback)(item => {
    return /*#__PURE__*/_react.default.createElement(_waterfall_sidebar_item.WaterfallSidebarItem, {
      item: item,
      renderFilterScreenReaderText: hasFilters && !onlyHighlighted,
      onClick: onSidebarClick,
      highestIndex: highestSideBarIndex,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 9
      }
    });
  }, [hasFilters, onlyHighlighted, onSidebarClick, highestSideBarIndex]);
  (0, _public.useTrackMetric)({
    app: 'uptime',
    metric: 'waterfall_chart_view',
    metricType: _public.METRIC_TYPE.COUNT
  });
  (0, _public.useTrackMetric)({
    app: 'uptime',
    metric: 'waterfall_chart_view',
    metricType: _public.METRIC_TYPE.COUNT,
    delay: 15000
  });
  return /*#__PURE__*/_react.default.createElement(_waterfall.WaterfallProvider, {
    activeStep: activeStep,
    markerItems: markerItems,
    totalNetworkRequests: total,
    fetchedNetworkRequests: networkData.length,
    highlightedNetworkRequests: totalHighlightedRequests,
    data: series,
    onElementClick: (0, _react.useCallback)(onBarClick, [onBarClick]),
    onProjectionClick: (0, _react.useCallback)(onProjectionClick, [onProjectionClick]),
    onSidebarClick: onSidebarClick,
    showOnlyHighlightedNetworkRequests: onlyHighlighted,
    sidebarItems: sidebarItems,
    legendItems: legendItems,
    metadata: metadata,
    renderTooltipItem: (0, _react.useCallback)(tooltipProps => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
        color: String(tooltipProps === null || tooltipProps === void 0 ? void 0 : tooltipProps.colour),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 16
        }
      }, tooltipProps === null || tooltipProps === void 0 ? void 0 : tooltipProps.value);
    }, []),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall.WaterfallChart, {
    tickFormat: (0, _react.useCallback)(d => `${Number(d).toFixed(0)} ms`, []),
    domain: domain,
    barStyleAccessor: (0, _react.useCallback)(({
      datum
    }) => {
      var _datum$config;
      if (!((_datum$config = datum.config) !== null && _datum$config !== void 0 && _datum$config.isHighlighted)) {
        var _datum$config2;
        return {
          rect: {
            fill: (_datum$config2 = datum.config) === null || _datum$config2 === void 0 ? void 0 : _datum$config2.colour,
            opacity: '0.1'
          }
        };
      }
      return datum.config.colour;
    }, []),
    renderSidebarItem: renderSidebarItem,
    renderLegendItem: renderLegendItem,
    renderFlyout: renderFlyout,
    renderFilter: renderFilter,
    fullHeight: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }));
};
exports.WaterfallChartWrapper = WaterfallChartWrapper;