"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingListTable = PingListTable;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _translations = _interopRequireWildcard(require("./translations"));
var I18LABELS = _translations;
var _ping_status = require("./columns/ping_status");
var _location_name = require("./location_name");
var _constants = require("../../../../../common/constants");
var _ping_timestamp = require("./columns/ping_timestamp");
var _monitor_status_column = require("../../overview/monitor_list/columns/monitor_status_column");
var _ping_error = require("./columns/ping_error");
var _failed_step = require("./columns/failed_step");
var _response_code = require("./columns/response_code");
var _expand_row = require("./columns/expand_row");
var _ping_list = require("./ping_list");
var _actions = require("../../../state/actions");
var _journey = require("../../../state/actions/journey");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/ping_list/ping_list_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PingListTable({
  loading,
  error,
  pings,
  pagination,
  onChange,
  failedSteps
}) {
  var _pings$;
  const history = (0, _reactRouterDom.useHistory)();
  const [expandedRows, setExpandedRows] = (0, _react.useState)({});
  const expandedIdsToRemove = JSON.stringify(Object.keys(expandedRows).filter(e => !pings.some(({
    docId
  }) => docId === e)));
  const dispatch = (0, _reactRedux.useDispatch)();
  const pruneJourneysCallback = (0, _react.useCallback)(checkGroups => dispatch((0, _journey.pruneJourneyState)(checkGroups)), [dispatch]);
  (0, _react.useEffect)(() => {
    return () => {
      dispatch((0, _actions.clearPings)());
    };
  }, [dispatch]);
  (0, _react.useEffect)(() => {
    const parsed = JSON.parse(expandedIdsToRemove);
    if (parsed.length) {
      parsed.forEach(docId => {
        delete expandedRows[docId];
      });
      setExpandedRows(expandedRows);
    }
  }, [expandedIdsToRemove, expandedRows]);
  const expandedCheckGroups = pings.filter(p => Object.keys(expandedRows).some(f => p.docId === f)).map(({
    monitor: {
      check_group: cg
    }
  }) => cg);
  const expandedCheckGroupsStr = JSON.stringify(expandedCheckGroups);
  (0, _react.useEffect)(() => {
    pruneJourneysCallback(JSON.parse(expandedCheckGroupsStr));
  }, [pruneJourneysCallback, expandedCheckGroupsStr]);
  const hasStatus = pings.reduce((hasHttpStatus, currentPing) => {
    var _currentPing$http, _currentPing$http$res;
    return hasHttpStatus || !!((_currentPing$http = currentPing.http) !== null && _currentPing$http !== void 0 && (_currentPing$http$res = _currentPing$http.response) !== null && _currentPing$http$res !== void 0 && _currentPing$http$res.status_code);
  }, false);
  const hasError = pings.reduce((errorType, currentPing) => {
    var _currentPing$error;
    return errorType || !!((_currentPing$error = currentPing.error) !== null && _currentPing$error !== void 0 && _currentPing$error.type);
  }, false);
  const monitorType = pings === null || pings === void 0 ? void 0 : (_pings$ = pings[0]) === null || _pings$ === void 0 ? void 0 : _pings$.monitor.type;
  const columns = [{
    field: 'monitor.status',
    name: I18LABELS.STATUS_LABEL,
    render: (pingStatus, item) => /*#__PURE__*/_react.default.createElement(_ping_status.PingStatusColumn, {
      pingStatus: pingStatus,
      item: item,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 9
      }
    })
  }, {
    align: 'left',
    field: 'observer.geo.name',
    name: _translations.LOCATION_LABEL,
    render: location => /*#__PURE__*/_react.default.createElement(_location_name.LocationName, {
      location: location,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 37
      }
    })
  }, ...(monitorType === _constants.MONITOR_TYPES.BROWSER ? [{
    align: 'left',
    field: 'timestamp',
    name: _translations.TIMESTAMP_LABEL,
    render: (timestamp, item) => /*#__PURE__*/_react.default.createElement(_ping_timestamp.PingTimestamp, {
      checkGroup: item.monitor.check_group,
      label: (0, _monitor_status_column.getShortTimeStamp)((0, _moment.default)(timestamp)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 15
      }
    })
  }] : []),
  // ip column not needed for browser type
  ...(monitorType !== _constants.MONITOR_TYPES.BROWSER ? [{
    align: 'right',
    dataType: 'number',
    field: 'monitor.ip',
    name: _i18n.i18n.translate('xpack.uptime.pingList.ipAddressColumnLabel', {
      defaultMessage: 'IP'
    })
  }] : []), {
    align: 'center',
    field: 'monitor.duration.us',
    name: _i18n.i18n.translate('xpack.uptime.pingList.durationMsColumnLabel', {
      defaultMessage: 'Duration'
    }),
    render: duration => duration ? (0, _ping_list.formatDuration)(duration) : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "ping-list-duration-unavailable-tool-tip",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 148,
        columnNumber: 11
      }
    }, '--')
  }, ...(hasError ? [{
    field: 'error.type',
    name: _translations.ERROR_LABEL,
    width: '30%',
    render: (errorType, item) => /*#__PURE__*/_react.default.createElement(_ping_error.PingErrorCol, {
      ping: item,
      errorType: errorType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    })
  }] : []), ...(monitorType === _constants.MONITOR_TYPES.BROWSER ? [{
    field: 'monitor.status',
    align: 'left',
    name: _i18n.i18n.translate('xpack.uptime.pingList.columns.failedStep', {
      defaultMessage: 'Failed step'
    }),
    render: (_timestamp, item) => {
      var _item$monitor;
      return /*#__PURE__*/_react.default.createElement(_failed_step.FailedStep, {
        checkGroup: (_item$monitor = item.monitor) === null || _item$monitor === void 0 ? void 0 : _item$monitor.check_group,
        failedSteps: failedSteps,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 15
        }
      });
    }
  }] : []),
  // Only add this column is there is any status present in list
  ...(hasStatus ? [{
    field: 'http.response.status_code',
    align: 'right',
    name: /*#__PURE__*/_react.default.createElement(_ping_list.SpanWithMargin, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 19
      }
    }, _translations.RES_CODE_LABEL),
    render: statusCode => /*#__PURE__*/_react.default.createElement(_response_code.ResponseCodeColumn, {
      statusCode: statusCode,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 45
      }
    })
  }] : []), ...(monitorType !== _constants.MONITOR_TYPES.BROWSER ? [{
    align: 'right',
    width: '24px',
    isExpander: true,
    render: item => /*#__PURE__*/_react.default.createElement(_expand_row.ExpandRowColumn, {
      item: item,
      expandedRows: expandedRows,
      setExpandedRows: setExpandedRows,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 15
      }
    })
  }] : [])];
  const getRowProps = item => {
    if (monitorType !== _constants.MONITOR_TYPES.BROWSER) {
      return {};
    }
    const {
      monitor
    } = item;
    return {
      height: '85px',
      'data-test-subj': `row-${monitor.check_group}`,
      onClick: evt => {
        const targetElem = evt.target;

        // we dont want to capture image click event
        if (targetElem.tagName !== 'IMG' && targetElem.tagName !== 'path') {
          history.push(`/journey/${monitor.check_group}/steps`);
        }
      }
    };
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: loading,
    columns: columns,
    error: error === null || error === void 0 ? void 0 : error.message,
    items: pings,
    itemId: "docId",
    itemIdToExpandedRowMap: expandedRows,
    pagination: pagination,
    noItemsMessage: loading ? _i18n.i18n.translate('xpack.uptime.pingList.pingsLoadingMesssage', {
      defaultMessage: 'Loading history...'
    }) : _i18n.i18n.translate('xpack.uptime.pingList.pingsUnavailableMessage', {
      defaultMessage: 'No history found'
    }),
    tableLayout: "auto",
    rowProps: getRowProps,
    onChange: onChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 5
    }
  });
}