"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepImagePopover = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _no_image_available = require("./no_image_available");
var _translations = require("./translations");
var _use_composite_image = require("../../../../../hooks/use_composite_image");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/ping_list/columns/ping_timestamp/step_image_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const POPOVER_IMG_HEIGHT = 360;
const POPOVER_IMG_WIDTH = 640;
const StepImage = (0, _common.euiStyled)(_eui.EuiImage)`
  &&& .euiImageFullScreenWrapper {
    figcaption {
      display: flex;
    }
  }
`;
const DefaultImage = ({
  captionContent,
  imageCaption,
  imageData
}) => imageData ? /*#__PURE__*/_react.default.createElement(StepImage, {
  allowFullScreen: true,
  alt: captionContent,
  caption: imageCaption,
  "data-test-subj": "pingTimestampImage",
  hasShadow: true,
  url: imageData,
  size: "s",
  className: "syntheticsStepImage",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 5
  }
}) : /*#__PURE__*/_react.default.createElement(_no_image_available.LoadingImageState, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 5
  }
});

/**
 * This component provides an intermediate step for composite images. It causes a loading spinner to appear
 * while the image is being re-assembled, then calls the default image component and provides a data URL for the image.
 */
const RecomposedScreenshotImage = ({
  captionContent,
  imageCaption,
  imageData,
  imgRef,
  setImageData
}) => {
  // initially an undefined URL value is passed to the image display, and a loading spinner is rendered.
  // `useCompositeImage` will call `setImageData` when the image is composited, and the updated `imageData` will display.
  (0, _use_composite_image.useCompositeImage)(imgRef, setImageData, imageData);
  return /*#__PURE__*/_react.default.createElement(DefaultImage, {
    captionContent: captionContent,
    imageCaption: imageCaption,
    imageData: imageData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  });
};
const StepImageComponent = ({
  captionContent,
  imageCaption,
  imageData,
  imgRef,
  imgSrc,
  setImageData
}) => {
  if (imgSrc) {
    return /*#__PURE__*/_react.default.createElement(DefaultImage, {
      captionContent: captionContent,
      imageCaption: imageCaption,
      imageData: imageData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    });
  } else if (imgRef) {
    return /*#__PURE__*/_react.default.createElement(RecomposedScreenshotImage, {
      captionContent: captionContent,
      imageCaption: imageCaption,
      imageData: imageData,
      imgRef: imgRef,
      setImageData: setImageData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 7
      }
    });
  }
  return null;
};
const StepImagePopover = ({
  captionContent,
  imageCaption,
  imgRef,
  imgSrc,
  isImagePopoverOpen
}) => {
  const [imageData, setImageData] = _react.default.useState(imgSrc || undefined);
  _react.default.useEffect(() => {
    // for legacy screenshots, when a new image arrives, we must overwrite it
    if (imgSrc && imgSrc !== imageData) {
      setImageData(imgSrc);
    }
  }, [imgSrc, imageData]);
  const setImageDataCallback = _react.default.useCallback(newImageData => setImageData(newImageData), [setImageData]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "leftDown",
    button: /*#__PURE__*/_react.default.createElement(StepImageComponent, {
      captionContent: captionContent,
      imageCaption: imageCaption,
      imgRef: imgRef,
      imgSrc: imgSrc,
      setImageData: setImageDataCallback,
      imageData: imageData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }),
    isOpen: isImagePopoverOpen,
    closePopover: () => {},
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 5
    }
  }, imageData ? /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: _translations.fullSizeImageAlt,
    url: imageData,
    style: {
      height: POPOVER_IMG_HEIGHT,
      width: POPOVER_IMG_WIDTH,
      objectFit: 'contain'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_no_image_available.LoadingImageState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }));
};
exports.StepImagePopover = StepImagePopover;