"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoImageAvailable = exports.LoadingImageState = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/ping_list/columns/ping_timestamp/no_image_available.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BorderedText = (0, _common.euiStyled)(_eui.EuiText)`
  display: flex;
  align-items: center;
  width: 120px;
  height: 67.5px;
  justify-content: center;
  text-align: center;
  border: 1px solid ${props => props.theme.eui.euiColorLightShade};
`;
const NoImageAvailable = () => {
  return /*#__PURE__*/_react.default.createElement(BorderedText, {
    "data-test-subj": "pingTimestampNoImageAvailable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.synthetics.screenshot.noImageMessage",
    defaultMessage: "No image available",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  })));
};
exports.NoImageAvailable = NoImageAvailable;
const BorderedTextLoading = (0, _common.euiStyled)(_eui.EuiText)`
  display: flex;
  align-items: center;
  width: 120px;
  height: 65.5px;
  justify-content: center;
  text-align: center;
  border: 1px solid ${props => props.theme.eui.euiColorLightShade};
`;
const LoadingImageState = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(BorderedTextLoading, {
    "data-test-subj": "pingTimestampSpinner",
    "aria-label": _translations.imageLoadingSpinnerAriaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.synthetics.screenshot.loadingImageMessage",
    defaultMessage: "Loading",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }))));
};
exports.LoadingImageState = LoadingImageState;