"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingHistogram = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/observability-shared-plugin/public");
var _charts = require("../../common/charts");
var _actions = require("../../../state/actions");
var _selectors = require("../../../state/selectors");
var _hooks = require("../../../hooks");
var _higher_order = require("../../common/higher_order");
var _contexts = require("../../../contexts");
var _use_overview_filter_check = require("../../../hooks/use_overview_filter_check");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/ping_histogram/ping_histogram_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Container = ({
  height
}) => {
  const {
    query,
    absoluteDateRangeStart,
    absoluteDateRangeEnd,
    dateRangeStart: dateStart,
    dateRangeEnd: dateEnd
  } = (0, _hooks.useGetUrlParams)();
  const {
    filterCheck,
    pending
  } = (0, _use_overview_filter_check.useOverviewFilterCheck)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const monitorId = (0, _hooks.useMonitorId)();
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const esKuery = (0, _reactRedux.useSelector)(_selectors.esKuerySelector);
  const {
    loading,
    pingHistogram: data
  } = (0, _reactRedux.useSelector)(_selectors.selectPingHistogram);
  const timeZone = (0, _public.useTimeZone)();
  (0, _react.useEffect)(() => {
    if (monitorId) {
      // we don't need filter check on monitor details page, where we have monitorId defined
      dispatch(_actions.getPingHistogram.get({
        monitorId,
        dateStart,
        dateEnd,
        query,
        filters: esKuery,
        timeZone
      }));
    } else {
      filterCheck(() => dispatch(_actions.getPingHistogram.get({
        monitorId,
        dateStart,
        dateEnd,
        query,
        filters: esKuery,
        timeZone
      })));
    }
  }, [filterCheck, dateStart, dateEnd, monitorId, lastRefresh, esKuery, dispatch, query, timeZone]);
  return /*#__PURE__*/_react.default.createElement(_charts.PingHistogramComponent, {
    data: data,
    absoluteStartDate: absoluteDateRangeStart,
    absoluteEndDate: absoluteDateRangeEnd,
    height: height,
    loading: loading || pending,
    timeZone: timeZone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  });
};
const PingHistogram = exports.PingHistogram = (0, _higher_order.withResponsiveWrapper)(Container);