"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMLJobLinkHref = exports.MLJobLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _url = _interopRequireDefault(require("url"));
var _eui = require("@elastic/eui");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _lib = require("../../../../../common/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/ml/ml_job_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getMLJobLinkHref = ({
  basePath,
  monitorId,
  dateRange
}) => {
  const query = {
    ml: {
      jobIds: [(0, _lib.getMLJobId)(monitorId)]
    },
    refreshInterval: {
      pause: true,
      value: 0
    },
    time: dateRange
  };
  const queryParams = {
    mlExplorerFilter: {
      filterActive: true,
      filteredFields: ['monitor.id', monitorId]
    },
    mlExplorerSwimlane: {
      viewByFieldName: 'observer.geo.name'
    }
  };
  const path = '/explorer';
  return _url.default.format({
    pathname: basePath + '/app/ml',
    hash: `${path}?_g=${_rison.default.encode(query)}` + (monitorId ? `&_a=${_rison.default.encode(queryParams)}` : '')
  });
};
exports.getMLJobLinkHref = getMLJobLinkHref;
const MLJobLink = ({
  basePath,
  monitorId,
  dateRange,
  children
}) => {
  const href = getMLJobLinkHref({
    basePath,
    monitorId,
    dateRange
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsMLJobLinkButton",
    children: children,
    size: "s",
    href: href,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  });
};
exports.MLJobLink = MLJobLink;