"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MLIntegrationComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _ml_flyout_container = require("./ml_flyout_container");
var _selectors = require("../../../state/selectors");
var _actions = require("../../../state/actions");
var _confirm_delete = require("./confirm_delete");
var _contexts = require("../../../contexts");
var labels = _interopRequireWildcard(require("./translations"));
var _manage_ml_job = require("./manage_ml_job");
var _hooks = require("../../../hooks");
var _lib = require("../../../../../common/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/ml/ml_integeration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MLIntegrationComponent = () => {
  const [isMlFlyoutOpen, setIsMlFlyoutOpen] = (0, _react.useState)(false);
  const [isConfirmDeleteJobOpen, setIsConfirmDeleteJobOpen] = (0, _react.useState)(false);
  const {
    lastRefresh,
    refreshApp
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const {
    services: {
      notifications,
      rendering
    }
  } = (0, _public.useKibana)();
  const monitorId = (0, _hooks.useMonitorId)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const isMLAvailable = (0, _reactRedux.useSelector)(_selectors.hasMLFeatureSelector);
  const deleteMLJob = () => dispatch(_actions.deleteMLJobAction.get({
    monitorId: monitorId
  }));
  const isMLJobDeleting = (0, _reactRedux.useSelector)(_selectors.isMLJobDeletingSelector);
  const {
    data: jobDeletionSuccess
  } = (0, _reactRedux.useSelector)(_selectors.isMLJobDeletedSelector);
  const {
    data: uptimeJobs
  } = (0, _reactRedux.useSelector)(_selectors.hasMLJobSelector);
  const hasMLJob = !!(uptimeJobs !== null && uptimeJobs !== void 0 && uptimeJobs.jobsExist) && !!uptimeJobs.jobs.find(job => job.id === (0, _lib.getMLJobId)(monitorId));
  (0, _react.useEffect)(() => {
    if (isMLAvailable) {
      dispatch(_actions.getExistingMLJobAction.get({
        monitorId: monitorId
      }));
    }
  }, [dispatch, isMLAvailable, monitorId, lastRefresh]);
  (0, _react.useEffect)(() => {
    var _jobDeletionSuccess$g;
    if (isConfirmDeleteJobOpen && jobDeletionSuccess !== null && jobDeletionSuccess !== void 0 && (_jobDeletionSuccess$g = jobDeletionSuccess[(0, _lib.getMLJobId)(monitorId)]) !== null && _jobDeletionSuccess$g !== void 0 && _jobDeletionSuccess$g.deleted) {
      setIsConfirmDeleteJobOpen(false);
      if (notifications && rendering) {
        notifications.toasts.addSuccess({
          title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("p", {
            "data-test-subj": "uptimeMLJobSuccessfullyDeleted",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 66,
              columnNumber: 13
            }
          }, labels.JOB_DELETION), rendering),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement("p", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 69,
              columnNumber: 30
            }
          }, labels.JOB_DELETION_SUCCESS), rendering),
          toastLifeTimeMs: 3000
        });
      }
      dispatch((0, _actions.resetMLState)());
      refreshApp();
    }
    return () => {
      dispatch((0, _actions.resetMLState)());
    };
  }, [isMLJobDeleting, isConfirmDeleteJobOpen, jobDeletionSuccess, monitorId, refreshApp, notifications, dispatch, rendering]);
  const onEnableJobClick = () => {
    setIsMlFlyoutOpen(true);
  };
  const closeFlyout = () => {
    setIsMlFlyoutOpen(false);
  };
  const confirmDeleteMLJob = () => {
    setIsConfirmDeleteJobOpen(true);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_manage_ml_job.ManageMLJobComponent, {
    hasMLJob: hasMLJob,
    onEnableJob: onEnableJobClick,
    onJobDelete: confirmDeleteMLJob,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }), isMlFlyoutOpen && /*#__PURE__*/_react.default.createElement(_ml_flyout_container.MachineLearningFlyout, {
    onClose: closeFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 26
    }
  }), isConfirmDeleteJobOpen && /*#__PURE__*/_react.default.createElement(_confirm_delete.ConfirmJobDeletion, {
    onConfirm: deleteMLJob,
    loading: isMLJobDeleting,
    onCancel: () => {
      setIsConfirmDeleteJobOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 9
    }
  }));
};
exports.MLIntegrationComponent = MLIntegrationComponent;