"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeprecateNoticeModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/fleet_package/deprecate_notice_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DeprecateNoticeModal = ({
  onCancel
}) => {
  const {
    application
  } = (0, _public.useKibana)().services;
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    titleProps: {
      id: modalTitleId
    },
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, HEADER_TEXT, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cheer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 24,
        columnNumber: 25
      }
    })),
    onCancel: onCancel,
    onConfirm: () => {
      application === null || application === void 0 ? void 0 : application.navigateToApp('synthetics');
    },
    confirmButtonText: GO_SYNTHETICS_TEXT,
    cancelButtonText: GO_BACK_TEXT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.description",
    defaultMessage: "The Elastic Synthetics integration is deprecated. Instead, you can now monitor endpoints, pages, and user journeys directly in the Synthetics app much more efficiently:",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.addPrivateLocations",
    defaultMessage: "Add private locations against your fleet policies",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.manageMonitors",
    defaultMessage: "Manage lightweight and browser monitors from a single place",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.elasticManagedLocations",
    defaultMessage: "Run monitors in multiple locations managed by Elastic, or from your own private locations",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("li", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.automateMonitors",
    defaultMessage: "Automate the creation of your monitors using project monitors",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.deprecateNoticeModal.forMoreInformation",
    defaultMessage: "For more information, {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "syntheticsDeprecateNoticeModalLink",
        target: "_blank",
        href: "https://www.elastic.co/guide/en/observability/current/monitor-uptime-synthetics.html",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 15
        }
      }, READ_DOCS_TEXT)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  })));
};
exports.DeprecateNoticeModal = DeprecateNoticeModal;
const HEADER_TEXT = _i18n.i18n.translate('xpack.uptime.deprecateNoticeModal.headerText', {
  defaultMessage: 'Synthetic Monitoring is now available out of the box in Synthetics'
});
const GO_BACK_TEXT = _i18n.i18n.translate('xpack.uptime.deprecateNoticeModal.goBack', {
  defaultMessage: 'Go back'
});
const READ_DOCS_TEXT = _i18n.i18n.translate('xpack.uptime.deprecateNoticeModal.readDocs', {
  defaultMessage: 'read docs.'
});
const GO_SYNTHETICS_TEXT = _i18n.i18n.translate('xpack.uptime.deprecateNoticeModal.goToSynthetics', {
  defaultMessage: 'Go to Synthetics'
});