"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LocationLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/common/location_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const locationDocsLink = 'https://www.elastic.co/guide/en/beats/heartbeat/current/configuration-observer-options.html';

/**
 * Renders some location text, or directs the user to the docs where
 * they can learn to configure location.
 */
const LocationLink = ({
  location,
  textSize
}) => {
  return location ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: textSize || 's',
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, location) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsLocationLinkAddLocationLink",
    href: locationDocsLink,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.uptime.monitorList.geoName.helpLinkAnnotation', {
    defaultMessage: 'Add location',
    description: 'Text that instructs the user to navigate to our docs to add a geographic location to their data'
  }));
};
exports.LocationLink = LocationLink;