"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingHistogramComponent = void 0;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _moment = _interopRequireDefault(require("moment"));
var _public = require("@kbn/kibana-react-plugin/public");
var _helper = require("../../../lib/helper");
var _chart_wrapper = require("./chart_wrapper");
var _hooks = require("../../../hooks");
var _chart_empty_state = require("./chart_empty_state");
var _utils = require("./utils");
var _translations = require("../../../../../common/translations/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/common/charts/ping_histogram.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PingHistogramComponent = ({
  absoluteStartDate,
  absoluteEndDate,
  data,
  loading = false,
  height,
  timeZone
}) => {
  var _data$histogram;
  const {
    services: {
      charts
    }
  } = (0, _public.useKibana)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const theme = (0, _eui.useEuiTheme)();
  const danger = theme.euiTheme.colors.danger;
  const gray = theme.euiTheme.colors.lightShade;
  const [_getUrlParams, updateUrlParams] = (0, _hooks.useUrlParams)();
  let content;
  if (!(data !== null && data !== void 0 && (_data$histogram = data.histogram) !== null && _data$histogram !== void 0 && _data$histogram.length) && !loading) {
    content = /*#__PURE__*/_react.default.createElement(_chart_empty_state.ChartEmptyState, {
      title: _i18n.i18n.translate('xpack.uptime.snapshot.noDataTitle', {
        defaultMessage: 'No ping data available'
      }),
      body: _i18n.i18n.translate('xpack.uptime.snapshot.noDataDescription', {
        defaultMessage: 'There are no pings in the selected time range.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 7
      }
    });
  } else {
    const {
      histogram,
      minInterval
    } = data !== null && data !== void 0 ? data : {};
    const onBrushEnd = ({
      x
    }) => {
      if (!x) {
        return;
      }
      const [min, max] = x;
      updateUrlParams({
        dateRangeStart: (0, _moment.default)(min).toISOString(),
        dateRangeEnd: (0, _moment.default)(max).toISOString()
      });
    };
    const onBarClicked = ([elementData]) => {
      updateUrlParams((0, _utils.getDateRangeFromChartElement)(elementData, minInterval));
    };
    const barData = [];
    histogram === null || histogram === void 0 ? void 0 : histogram.forEach(({
      x,
      upCount,
      downCount
    }) => {
      barData.push({
        x,
        y: downCount !== null && downCount !== void 0 ? downCount : 0,
        type: _translations.STATUS_DOWN_LABEL
      }, {
        x,
        y: upCount !== null && upCount !== void 0 ? upCount : 0,
        type: _translations.STATUS_UP_LABEL
      });
    });
    content = /*#__PURE__*/_react.default.createElement("div", {
      "aria-label": _i18n.i18n.translate('xpack.uptime.snapshotHistogram.description', {
        defaultMessage: 'Bar Chart showing uptime status over time from {startTime} to {endTime}.',
        values: {
          startTime: (0, _moment.default)(new Date(absoluteStartDate).valueOf()).fromNow(),
          endTime: (0, _moment.default)(new Date(absoluteEndDate).valueOf()).fromNow()
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_chart_wrapper.ChartWrapper, {
      height: height,
      loading: loading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
      xDomain: {
        minInterval,
        min: absoluteStartDate,
        max: absoluteEndDate
      },
      showLegend: false,
      onBrushEnd: onBrushEnd,
      onElementClick: onBarClicked,
      locale: _i18n.i18n.getLocale(),
      baseTheme: baseTheme,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
      id: _i18n.i18n.translate('xpack.uptime.snapshotHistogram.xAxisId', {
        defaultMessage: 'Ping X Axis'
      }),
      position: _charts.Position.Bottom,
      showOverlappingTicks: false,
      tickFormat: (0, _charts.timeFormatter)((0, _helper.getChartDateLabel)(absoluteStartDate, absoluteEndDate)),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
      id: _i18n.i18n.translate('xpack.uptime.snapshotHistogram.yAxisId', {
        defaultMessage: 'Ping Y Axis'
      }),
      position: "left",
      tickFormat: d => (0, _numeral.default)(d).format('0'),
      labelFormat: d => (0, _numeral.default)(d).format('0a'),
      title: _i18n.i18n.translate('xpack.uptime.snapshotHistogram.yAxis.title', {
        defaultMessage: 'Pings',
        description: 'The label on the y-axis of a chart that displays the number of times Heartbeat has pinged a set of services/websites.'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      color: [danger, gray],
      data: barData,
      id: _translations.STATUS_DOWN_LABEL,
      name: _i18n.i18n.translate('xpack.uptime.snapshotHistogram.series.pings', {
        defaultMessage: 'Monitor Pings'
      }),
      stackAccessors: ['x'],
      splitSeriesAccessors: ['type'],
      timeZone: timeZone,
      xAccessor: "x"
      // Defaults to multi layer time axis as of Elastic Charts v70
      ,
      xScaleType: _charts.ScaleType.Time,
      yAccessors: ['y'],
      yScaleType: _charts.ScaleType.Linear,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.snapshot.pingsOverTimeTitle",
    defaultMessage: "Pings over time",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }))))), content);
};
exports.PingHistogramComponent = PingHistogramComponent;