"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GreenCheckIcon = exports.DonutChart = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _charts = require("@elastic/charts");
var _public = require("@kbn/kibana-react-plugin/public");
var _donut_chart_legend = require("./donut_chart_legend");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/common/charts/donut_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const GreenCheckIcon = exports.GreenCheckIcon = (0, _styledComponents.default)(_eui.EuiIcon)`
  height: 42px;
  width: 42px;
  color: #017d73;
  top: 51px;
  left: 51px;
  position: absolute;
`;
const themeOverrides = {
  chartMargins: {
    top: 0,
    bottom: 0,
    left: 0,
    right: 0
  },
  partition: {
    linkLabel: {
      maximumSection: Infinity
    },
    idealFontSizeJump: 1.1,
    outerSizeRatio: 0.9,
    emptySizeRatio: 0.4,
    circlePadding: 4
  }
};
const DonutChart = ({
  height,
  down,
  up
}) => {
  const theme = (0, _eui.useEuiTheme)();
  const danger = theme.euiTheme.colors.danger;
  const gray = theme.euiTheme.colors.lightShade;
  const {
    services: {
      charts
    }
  } = (0, _public.useKibana)();
  const baseTheme = charts.theme.useChartsBaseTheme();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      position: 'relative'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: height,
    "aria-label": _i18n.i18n.translate('xpack.uptime.snapshot.donutChart.ariaLabel', {
      defaultMessage: 'Pie chart showing the current status. {down} of {total} monitors are down.',
      values: {
        down,
        total: up + down
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: [themeOverrides],
    baseTheme: baseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    id: "spec_1",
    data: [{
      value: down,
      label: 'Down'
    }, {
      value: up,
      label: 'Up'
    }],
    layout: _charts.PartitionLayout.sunburst,
    valueAccessor: d => d.value,
    layers: [{
      groupByRollup: d => d.label,
      nodeLabel: d => d,
      shape: {
        fillColor: dataName => {
          return dataName === 'Down' ? danger : gray;
        }
      }
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  })), down === 0 && /*#__PURE__*/_react.default.createElement(GreenCheckIcon, {
    className: "greenCheckIcon",
    type: "checkInCircleFilled",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 24
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_donut_chart_legend.DonutChartLegend, {
    down: down,
    up: up,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  })));
};
exports.DonutChart = DonutChart;