"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationTooltip = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/common/charts/annotation_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Header = _styledComponents.default.div`
  font-weight: bold;
  padding-left: 4px;
`;
const RecordSeverity = _styledComponents.default.div`
  font-weight: bold;
  border-left: 4px solid ${props => props.color};
  padding-left: 2px;
`;
const TimeDiv = _styledComponents.default.div`
  font-weight: 500;
  border-bottom: 1px solid gray;
  padding-bottom: 2px;
`;
const AnnotationTooltip = ({
  details
}) => {
  const data = JSON.parse(details);
  function capitalizeFirstLetter(str) {
    return str.charAt(0).toUpperCase() + str.slice(1);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(TimeDiv, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, (0, _moment.default)(data.time).format('lll')), /*#__PURE__*/_react.default.createElement(Header, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.charts.mlAnnotation.header",
    defaultMessage: "Score: {score}",
    values: {
      score: data.score.toFixed(2)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(RecordSeverity, {
    color: data.color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.charts.mlAnnotation.severity",
    defaultMessage: "Severity: {severity}",
    values: {
      severity: capitalizeFirstLetter(data.severity)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  })));
};
exports.AnnotationTooltip = AnnotationTooltip;