"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNoDataConfig = useNoDataConfig;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _contexts = require("../contexts");
var _selectors = require("../state/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useNoDataConfig() {
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const {
    services: {
      docLinks
    }
  } = (0, _public.useKibana)();
  const {
    data
  } = (0, _reactRedux.useSelector)(_selectors.indexStatusSelector);

  // Returns no data config when there is no historical data
  if (data && !data.indexExists) {
    return {
      action: {
        beats: {
          title: _i18n.i18n.translate('xpack.uptime.noDataConfig.beatsCard.title', {
            defaultMessage: 'Add monitors with Heartbeat'
          }),
          description: _i18n.i18n.translate('xpack.uptime.noDataConfig.beatsCard.description', {
            defaultMessage: 'Proactively monitor the availability of your sites and services. Receive alerts and resolve issues faster to optimize your users experience.'
          }),
          href: basePath + `/app/home#/tutorial/uptimeMonitors`,
          docsLink: docLinks.links.observability.guide
        }
      }
    };
  }
}