"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimePageTemplateComponent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _constants = require("../../../common/constants");
var _use_no_data_config = require("./use_no_data_config");
var _empty_state_loading = require("../components/overview/empty_state/empty_state_loading");
var _empty_state_error = require("../components/overview/empty_state/empty_state_error");
var _use_has_data = require("../components/overview/empty_state/use_has_data");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767906851655284711/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/app/uptime_page_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UptimePageTemplateComponent = ({
  path,
  pageHeader,
  children,
  ...pageTemplateProps
}) => {
  const {
    services: {
      observabilityShared
    }
  } = (0, _public.useKibana)();
  const PageTemplateComponent = observabilityShared.navigation.PageTemplate;
  const noDataConfig = (0, _use_no_data_config.useNoDataConfig)();
  const {
    loading,
    error,
    data
  } = (0, _use_has_data.useHasData)();
  const {
    inspectorAdapters
  } = (0, _public2.useInspectorContext)();
  (0, _react.useEffect)(() => {
    inspectorAdapters.requests.reset();
  }, [inspectorAdapters.requests]);
  if (error && path !== _constants.SETTINGS_ROUTE) {
    return /*#__PURE__*/_react.default.createElement(_empty_state_error.EmptyStateError, {
      errors: [error],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 12
      }
    });
  }
  const isMainRoute = path === _constants.OVERVIEW_ROUTE || path === _constants.CERTIFICATES_ROUTE;
  const showLoading = loading && isMainRoute && !data;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(PageTemplateComponent, (0, _extends2.default)({
    pageHeader: pageHeader,
    "data-test-subj": noDataConfig ? 'data-missing' : undefined,
    noDataConfig: isMainRoute && !loading ? noDataConfig : undefined,
    isPageDataLoaded: loading === false && isMainRoute
  }, pageTemplateProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), showLoading && /*#__PURE__*/_react.default.createElement(_empty_state_loading.EmptyStateLoading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 25
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      visibility: showLoading ? 'hidden' : 'initial'
    },
    "data-test-subj": noDataConfig ? 'data-missing' : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  }, children)));
};
exports.UptimePageTemplateComponent = UptimePageTemplateComponent;