"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerUpdateIndexRoute = registerUpdateIndexRoute;
var _configSchema = require("@kbn/config-schema");
var _elasticsearch = require("@elastic/elasticsearch");
var _upgradeAssistantPkgServer = require("@kbn/upgrade-assistant-pkg-server");
var _constants = require("../../common/constants");
var _update_index = require("../lib/update_index");
var _version = require("../lib/version");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerUpdateIndexRoute({
  router,
  lib: {
    handleEsError
  },
  log,
  current
}) {
  const BASE_PATH = `${_constants.API_BASE_PATH}/update_index`;
  router.post({
    path: `${BASE_PATH}/{index}`,
    security: {
      authz: {
        enabled: false,
        reason: 'Relies on es and saved object clients for authorization'
      }
    },
    options: {
      access: 'public',
      summary: `Perform certain update operations on a given index. Currently supported ones are: 'blockWrite' and 'unfreeze'`
    },
    validate: {
      params: _configSchema.schema.object({
        index: _configSchema.schema.string()
      }),
      body: _configSchema.schema.object({
        operations: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.literal('blockWrite'), _configSchema.schema.literal('unfreeze')]))
      })
    }
  }, (0, _upgradeAssistantPkgServer.versionCheckHandlerWrapper)(current.major)(async ({
    core
  }, request, response) => {
    const {
      elasticsearch: {
        client
      }
    } = await core;
    const {
      index
    } = request.params;
    const {
      operations
    } = request.body;
    try {
      await (0, _update_index.updateIndex)({
        esClient: client.asCurrentUser,
        index,
        operations,
        log,
        versionService: _version.versionService
      });
      return response.ok();
    } catch (err) {
      if (err instanceof _elasticsearch.errors.ResponseError) {
        return handleEsError({
          error: err,
          response
        });
      }
      throw err;
    }
  }));
}