"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeAssistantServerPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _upgradeAssistantPkgServer = require("@kbn/upgrade-assistant-pkg-server");
var _constants = require("../common/constants");
var _telemetry = require("./lib/telemetry");
var _version = require("./lib/version");
var _register_routes = require("./routes/register_routes");
var _shared_imports = require("./shared_imports");
var _data_source_exclusions = require("./lib/data_source_exclusions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class UpgradeAssistantServerPlugin {
  constructor({
    logger,
    env,
    config
  }) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "initialFeatureSet", void 0);
    (0, _defineProperty2.default)(this, "initialDataSourceExclusions", void 0);
    // Properties set at start
    (0, _defineProperty2.default)(this, "savedObjectsServiceStart", void 0);
    (0, _defineProperty2.default)(this, "securityPluginStart", void 0);
    this.logger = logger.get();
    this.kibanaVersion = env.packageInfo.version;
    const {
      featureSet,
      dataSourceExclusions
    } = config.get();
    this.initialFeatureSet = featureSet;
    this.initialDataSourceExclusions = Object.assign({}, _data_source_exclusions.defaultExclusions, dataSourceExclusions);
  }
  setup(coreSetup, pluginSetup) {
    const {
      http,
      getStartServices,
      savedObjects
    } = coreSetup;
    const {
      usageCollection,
      features,
      licensing,
      logsShared,
      security
    } = pluginSetup;
    savedObjects.registerType(_upgradeAssistantPkgServer.mlSavedObjectType);
    features.registerElasticsearchFeature({
      id: 'upgrade_assistant',
      management: {
        stack: ['upgrade_assistant']
      },
      privileges: [{
        requiredClusterPrivileges: ['manage'],
        ui: []
      }]
    });

    // We need to initialize the deprecation logs plugin so that we can
    // navigate from this app to the observability app using a source_id.
    logsShared === null || logsShared === void 0 ? void 0 : logsShared.logViews.defineInternalLogView(_constants.DEPRECATION_LOGS_SOURCE_ID, {
      name: 'deprecationLogs',
      description: 'deprecation logs',
      logIndices: {
        type: 'index_name',
        indexName: _constants.DEPRECATION_LOGS_INDEX
      },
      logColumns: [{
        timestampColumn: {
          id: 'timestampField'
        }
      }, {
        messageColumn: {
          id: 'messageField'
        }
      }]
    });
    const router = http.createRouter();
    // Initialize version service with current kibana version
    _version.versionService.setup(this.kibanaVersion);
    const dependencies = {
      router,
      log: this.logger,
      licensing,
      getSavedObjectsService: () => {
        if (!this.savedObjectsServiceStart) {
          throw new Error('Saved Objects Start service not available');
        }
        return this.savedObjectsServiceStart;
      },
      getSecurityPlugin: () => this.securityPluginStart,
      lib: {
        handleEsError: _shared_imports.handleEsError
      },
      config: {
        featureSet: this.initialFeatureSet,
        dataSourceExclusions: this.initialDataSourceExclusions,
        isSecurityEnabled: () => security !== undefined && security.license.isEnabled()
      },
      current: _version.versionService.getCurrentVersion(),
      defaultTarget: _version.versionService.getNextMajorVersion(),
      version: _version.versionService,
      cleanupReindexOperations: async indexNames => {
        const [, {
          reindexService
        }] = await getStartServices();
        return reindexService.cleanupReindexOperations(indexNames);
      }
    };
    (0, _register_routes.registerRoutes)(dependencies);
    if (usageCollection) {
      void getStartServices().then(([{
        elasticsearch
      }]) => {
        (0, _telemetry.registerUpgradeAssistantUsageCollector)({
          elasticsearch,
          usageCollection
        });
      });
    }
  }
  start({
    savedObjects
  }, {
    security
  }) {
    this.savedObjectsServiceStart = savedObjects;
    this.securityPluginStart = security;
  }
  stop() {}
}
exports.UpgradeAssistantServerPlugin = UpgradeAssistantServerPlugin;